local Object = require "classic"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"

local GestureAction = Object:extend();


function GestureAction:new()
  self.vec2 = mathfunction.vector2(-1,-1);
end

--是否出现关键动作
function GestureAction:isAction(action)
  if action == "Left_hand_up" then
    if self.vec2:x() < 0 and self.vec2:x() > -1 and self.vec2:y() > 0 and self.vec2:y() < 1 then  --模拟左手抬起动作
      return true;
    else
      return false;
    end
  elseif action == "right_hand_up" then
    if self.vec2:x() > 0 and self.vec2:x() < 1 and self.vec2:y() > 0 and self.vec2:y() < 1 then  --模拟右手抬起动作
      return true;
    else
      return false;
    end
  end
end


function GestureAction:__tostring()
  return "GestureAction"
end

function GestureAction:SetSimulateActionPoint(point)
  self.vec2 = point;
end


return GestureAction;