local facecover = require "facecute.facechange.facecover"
local renderqueue = require "apolloutility.renderqueue"
local mathfunction = require "mathfunction"
local apolloengine = require "apolloengine"
local facedefined = require "facecute.facechange.facedefined"
--facecover类型
local facecover3 = facecover:extend();


function facecover3:Play(delay, loop, lastingFrame, fadingFrame, donecallback)
    self:setState("playing")
    self:PlayAnimation(delay ,loop,lastingFrame,fadingFrame);
end

function facecover3:Stop()
    self:SetVisible(false);
    self:setState("invisible")
    self.animloop = 0;
    self.animdelay = 0;
    self.animlast = 0;
    self.animfade = 0;
    self.animTime = -1.0;
end

function facecover3:Pause()
    self:setState("paused")
end


function facecover3:GetRenderOrder()
  local offset = self.renderoffset;
  local zPos = self.zPos+offset;
  return zPos;
end

function facecover3:ParseConfig(config,para, compress_root)
  
  self.renderoffset = -2000;
  local res = facecover3.super.ParseConfig(self,config,para, compress_root);
  self:SetRenderOrder(config["zPosition"]);
  return res;
end

function facecover3:SetRenderOrder(z)
  local zPos = z;
  self.zPos = z;

  if(zPos~=nil)
  then
    local offset = self.renderoffset;
    local bindboxV = mathfunction.Aabbox3d(mathfunction.vector3(-1,-1, offset + zPos -1),
    mathfunction.vector3(1,1,offset + zPos));
     self:SetBindBox(bindboxV);
     self:SetCull(false);
  end
end

function facecover3:PauseInFirstFrame()
    self:setState("first_frame")
end

function facecover3:PauseInLastFrame()
    self:setState("last_frame")
end

function facecover3:Hide()
    self:Stop();
    self:setState("invisible")
end


function facecover3:TestTrigger()
    if self.triggerFlag then
        self.triggerFlag = false
        return self.cur_state3
    end
    return nil
end

function facecover3:setState(state)
    if self.cur_state3 ~= state then
        self.triggerFlag = true
        self.cur_state3 = state
    end
end

function facecover3:PlayAnimation(delay ,loop,lastingFrame,fadingFrame )
  self.animloop = loop;
  self.animdelay = delay;
  self.animlast = lastingFrame;
  self.animfade = fadingFrame;
  self.animTime = 0.0;

  self:AnimUpdate(0);

end

function facecover3:AnimUpdate(timespan)
  if(self.bParse==false)
  then
     return;
  end
  
  if self.animTime == -1.0 then
      --local pic = self:Render();
     self:_ChangeVertexBuffer();
      return;
  end

  self.animTime = self.animTime + timespan;
  if self.animTime>=self.animdelay/self.fps then
      if self.isshow == false then
        self.texturereader:ReStart();
        self:SetVisible(true);
      end

      self:SetFade(1);
     if (self.animTime -self.animdelay/self.fps)  <self.animfade/self.fps then
        local len = self.animfade;
        local per = self.animTime*self.fps-self.animdelay;
        self:SetFade(per/len);
      end
      local pic = self:Render();
      if self.animloop>0 and self.texturereader:GetLoopCount()>=self.animloop then
        self.animTime = -1;
        self:Stop(self);
      end
  end
end

function facecover3:Render()
 if(self.bParse==false)
 then
    return;
 end
 local face = self.face;
 local timespan = self.timespan;
 local tex = renderqueue:GetLinkedTexture(self.renderLayer);
 self:SetParameter(apolloengine.ShaderEntity.TEXTURE_DIFFUSE, tex);
 if(self.bseq==false)
 then
   if not self.texturesplit then
     self:SetParameter(apolloengine.ShaderEntity.TEXTURE_BACKG, self.tex); 
   else
     self:SetParameter(apolloengine.ShaderEntity.TEXTURE_BACKG_RGB, self.tex); 
     self:SetParameter(apolloengine.ShaderEntity.TEXTURE_BACKG_ALPHA, self.atex); 
   end  
 else
   local slotindex = self.texturesplit 
     and apolloengine.ShaderEntity.TEXTURE_BACKG_RGB
     or apolloengine.ShaderEntity.TEXTURE_BACKG
   self.rgbtexture, pic, self.alphatexture = self.texturereader:Update(timespan);    
   if(self.rgbtexture~=nil)
   then
     self:SetParameter(slotindex, self.rgbtexture);
   end
   if self.alphatexture~=nil then
       self:SetParameter(apolloengine.ShaderEntity.TEXTURE_BACKG_ALPHA, self.alphatexture);
   end
 end
 
 self:_ChangeVertexBuffer();
 return pic;
end

function facecover3:SetFade(fade)
  self:SetParameter(apolloengine.ShaderEntity.UNIFORM_ALPHACOF,  mathfunction.vector1(fade));
end

function facecover3:new(maincamera)
  facecover3.super.new(self,maincamera);
  self.cur_state3 = "invisible";
  self.triggerFlag = false;
  self.animloop = 0;
  self.animdelay = 0;
  self.animlast = 0;
  self.animfade = 0;
  self.animTime = -1.0;
  self.fps = 25;
end

function facecover3:Update(timespan, face, position, rotation, action)
  self.timespan = timespan;
  self.face = face;
  self.action = action;
  self.curFrame= self.curFrame+1;
  self:ResetEvent();
  self:AnimUpdate(self.timespan );
  --local ii = self:Render( );
end

function facecover:GetMaterialPath(blendModeIndex)
  
  local materialPath;
  if self.texturesplit then
    materialPath = facedefined.materialPathSplit[blendModeIndex];
  else
    materialPath = facedefined.materialPath3[blendModeIndex];
  end  
  return materialPath;
  
end
return facecover3;