
local bezier = require "facecute.deformation.bezier"
local defordefined = require "facecute.deformation.defordefined"
local renderqueue = require "apolloutility.renderqueue"

--贝塞尔变形器
local bezier3New = bezier:extend();


function bezier3New:new(maincamera)
  bezier3New.super.new(self,maincamera);
  self.animLoop = 0
  self.currLoop = 0
end

function bezier3New:GetMaterialPath()
  return defordefined.bezier_material_path3;
end

function bezier3New:GetRenderOrder()
  return self.addIndex/10000+renderqueue:GetMaxFaceOrder();
end

function bezier3New:SetShow(isshow)
  self:SetVisible(isshow)
end

  ----------

function bezier3New:SetRootNode(rootNode)
  rootNode:AttachNode(self)
end

function bezier3New:Finished()
  if self.animLoop == 0 then
    return false
  end
  return self.currLoop >= self.animLoop
end

function bezier3New:SeekToFirst()

end

function bezier3New:SeekToMiddle()

end

function bezier3New:SeekToLast()

end

function bezier3New:Show(args)
  self:SetVisible(true)
end

function bezier3New:Hide(args)
  self:SetVisible(false)
  self.animLoop = 0
  self.currLoop = 0
end

function bezier3New:Start(args)
  self.animLoop = args.loop == nil and 0 or args.loop
end

function bezier3New:Stop(args)

end

function bezier3New:Update(timespan, face, position, rotation, action)
  self.timespan = timespan;
  self.frames = self.frames+1;
  self.action = action;
  self.face = face;
  self.curFrame= self.curFrame+1;
  self:Render();
  if self.animLoop > 0 and self.currLoop < self.animLoop then
    self.currLoop = self.currLoop + 1
  end
end

function bezier3New:SetFade(fade)

end

-----------


return bezier3New;
