local venuscore = require "venuscore"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local makeup_common = require "behavior.makeup.makeup_common"
local cv = require "computervisionfunction"

local makeup_face_seg = venuscore.VenusBehavior:extend("makeup_face_seg");


function makeup_face_seg:new()
  self.hasInit = false;
  self.render = nil
  self.FaceID = 1
  self.vertexStream = nil
  self.indexstream = nil
  self.vertexNumber = 0
  self.errorThreshold = 0.9
  self.recognition = nil
  self.segment = nil;
  self.EdgeFeatherRadius = 1;
end

function makeup_face_seg:_OnAwake(def)
  self:BInitialParameters();
end

function makeup_face_seg:_OnLateUpdate(def)
  if self.hasInit then
    self:IUpdateParameters()
  else
    self:BInitialParameters();
  end
end 

function makeup_face_seg:_OnDestroy()
  self:IDestroy(); --删除Script时需要删除动态创建的Node
end


--Base class methods that can be overwrite, beginning with "I,"I" was "implementation"
function makeup_face_seg:IInitialParameters()
  --return bool type flag
  --type:return true or return false
  return true
end

function makeup_face_seg:IUpdateParameters()
  self.segment = self:GetSegmentComponent();
  if self:GetOcclusionMode() ~= 2 then -- 非分割遮挡模式, 直接返回
    return true
  end
  self.render = self:BGetRender();
  if self.render and self.segment then
    self.segment.EdgeFeatherRadius = self.EdgeFeatherRadius;
    local materialEntity = self.render.MaterialEntities[1];
    local faceSegMaskPosition = self.segment:GetData(cv.SegmentComponent.mlFaceSegPosition)[cv.SegmentComponent.mlFaceSegPosition];

    materialEntity:SetParameter("_MaskMap",self.segment:GetMask());

    self.recognition = self:BGetRecongnition();
    local videoFrame = nil
    if self.recognition then
      videoFrame = self.recognition:GetDetectSize();
    end
    local index_vertex = self.vertexstream:GetAttributeIndex(apolloengine.ShaderEntity.ATTRIBUTE_POSITION);
    local leftTop = mathfunction.vector2(-1, 1);
    local leftBottom = mathfunction.vector2(-1, -1);
    local rightTop = mathfunction.vector2(1, 1);
    local rightBottom = mathfunction.vector2(1, -1);
    if faceSegMaskPosition and videoFrame then
      leftTop = mathfunction.vector2(2*faceSegMaskPosition[1]/videoFrame:x() - 1.0, 1.0 - 2*faceSegMaskPosition[2]/videoFrame:y());
      leftBottom = mathfunction.vector2(2*faceSegMaskPosition[5]/videoFrame:x() - 1.0, 1.0 - 2*(faceSegMaskPosition[6])/videoFrame:y());
      rightTop = mathfunction.vector2(2*(faceSegMaskPosition[3])/videoFrame:x() - 1.0, 1.0 - 2*faceSegMaskPosition[4]/videoFrame:y());
      rightBottom = mathfunction.vector2(2*(faceSegMaskPosition[7])/videoFrame:x() - 1.0, 1.0 - 2*(faceSegMaskPosition[8])/videoFrame:y());
      self.vertexstream:ChangeVertexDataWithAttributeFast(index_vertex,1,mathfunction.vector4(leftTop:x(), leftTop:y(), 0 , 1));
      self.vertexstream:ChangeVertexDataWithAttributeFast(index_vertex,2,mathfunction.vector4(leftBottom:x(), leftBottom:y(), 0 , 1));
      self.vertexstream:ChangeVertexDataWithAttributeFast(index_vertex,3,mathfunction.vector4(rightTop:x(), rightTop:y(), 0 , 1));
      self.vertexstream:ChangeVertexDataWithAttributeFast(index_vertex,4,mathfunction.vector4(rightBottom:x(), rightBottom:y(), 0 , 1));
      self.vertexstream:SetReflushInterval(1, 4);
      self.render:ChangeVertexBuffer(self.vertexstream);
    end 
  end
  return true
end

function makeup_face_seg:IDestroy()
  return true
end

function makeup_face_seg:BGetFaceID()
  return self.FaceID
end

function makeup_face_seg:BSetFaceID(value)
  self.FaceID = value;
  if self.segment then
    self.segment.FaceID = self.FaceID;
  end
end

function makeup_face_seg:BGetRender()
  if nil == self.render and nil~=self.Node then
      self.render = self.Node:GetComponent(apolloengine.Node.CT_RENDER);
      if nil == self.render then
          ERROR("[makeup_face_seg]: We Have No Render Component!")
          return nil
      end
  end
  return  self.render
end

function makeup_face_seg:BGetRecongnition()
  self.recognition = self.Node:GetComponent(apolloengine.Node.CT_CV_RECOGNITION);
  if nil == self.recognition then
    ERROR("[makeup_base]: We Have No Recognition Component!")
    return nil
  end
  return self.recognition
end

function makeup_face_seg:BInitialParameters()
  local result = self:IInitialParameters();
  self.hasInit = true;
  self.render = self:BGetRender()
  self.recognition = self:BGetRecongnition()
  self.segment = self:GetSegmentComponent();
  if self:GetOcclusionMode() ~= 2 then -- 非分割遮挡模式, 直接返回
    return true
  end
  if self.render then
    self.vertexstream = apolloengine.VertexStream();--创建顶点流
    self.vertexstream:SetVertexType(apolloengine.ShaderEntity.ATTRIBUTE_POSITION,
    apolloengine.VertexBufferEntity.DT_FLOAT,
    apolloengine.VertexBufferEntity.DT_HALF_FLOAT,
    4);
    self.vertexstream:SetVertexType(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0,
		apolloengine.VertexBufferEntity.DT_FLOAT,
		apolloengine.VertexBufferEntity.DT_HALF_FLOAT,
		2);
    self.vertexstream:ReserveBuffer(8); --把每一个面拆开渲染
    self.indexstream = apolloengine.IndicesStream(); 
    self.indexstream:SetIndicesType(apolloengine.IndicesBufferEntity.IT_UINT16);
    self.indexstream:ReserveBuffer(6);
    self.indexstream:PushIndicesData(0);
    self.indexstream:PushIndicesData(1);
    self.indexstream:PushIndicesData(2);
    self.indexstream:PushIndicesData(2);
    self.indexstream:PushIndicesData(1);
    self.indexstream:PushIndicesData(3);
    self.vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_POSITION,mathfunction.vector4(-1.0, 1.0, 0.0, 1.0));
    self.vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_POSITION,mathfunction.vector4(-1.0, -1.0, 0.0, 1.0));
    self.vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_POSITION,mathfunction.vector4(1.0, 1.0, 0.0, 1.0));
    self.vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_POSITION,mathfunction.vector4(1.0, -1.0, 0.0, 1.0));
    self.vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0, mathfunction.vector2(0, 0));
    self.vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0, mathfunction.vector2(0, 1));
    self.vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0, mathfunction.vector2(1, 0));
    self.vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0, mathfunction.vector2(1, 1));
    self.render:ChangeVertexBuffer(self.vertexstream);
    self.render:ChangeIndexBuffer(self.indexstream);
  end

  return result;
end

function makeup_face_seg:GetSegmentComponent()
  if nil ~= self.Node then
    self.segment = self.Node:GetComponent(apolloengine.Node.CT_CV_SEGMENT);
    if nil == self.segment then
      ERROR("[makeup_face_seg]: We Have No Segment Component!")
    end
    return self.segment;
  end
end

function makeup_face_seg:GetOcclusionMode()
  -- 美妆遮挡模式
  -- 0 : NONE_MODE, 默认
  -- 1 : LANDMARK_MODE, 关键点模式, 利用可见性
  -- 2 : SEGMENT_MODE, 分割模式, 使用人脸分割模型
  if nil ~= self.segment then
    return self.segment:GetOcclusionMode();
  else
    return 0
  end
end

makeup_face_seg:MemberRegister("FaceID", 
    venuscore.ScriptTypes.ComboType(
        makeup_common.faceId,    
        makeup_face_seg.BGetFaceID,
        makeup_face_seg.BSetFaceID));

return makeup_face_seg;
