local venuscore     = require "venuscore"
local apolloengine  = require "apolloengine"
local venusjson     = require "venusjson"
local mathfunction  = require "mathfunction"

local ConnectMeshBehavior = venuscore.VenusBehavior:extend("ConnectMeshBehavior")

function ConnectMeshBehavior:new()
  ConnectMeshBehavior.super.new(self)
  self.Config = ""
end

function ConnectMeshBehavior:_OnAwake()
  self.render = self.Node:GetComponent(apolloengine.Node.CT_RENDER)
end

function ConnectMeshBehavior:_OnUpdate(delta)
  if not self.edges or not self.other_render then
    return
  end
  
  local this_vs = self.render:GetVertexStream()
  local this_normals = this_vs:GetNormalData()
  local other_vs = self.other_render:GetVertexStream()
  local other_normals = other_vs:GetNormalData()
  for this_index_str, other_index in pairs(self.edges) do
    local this_normal_index = tonumber(this_index_str) + 1
    local other_normal_index = other_index + 1
    local this_normal = mathfunction.vector3(unpack(this_normals[this_normal_index]))
    local other_normal = mathfunction.vector3(unpack(other_normals[other_normal_index]))
    local mid_normal = (this_normal + other_normal) / 2
    this_vs:ChangeVertexData(apolloengine.ShaderEntity.ATTRIBUTE_NORMAL, this_normal_index, mid_normal)
    other_vs:ChangeVertexData(apolloengine.ShaderEntity.ATTRIBUTE_NORMAL, other_normal_index, mid_normal)
  end
  self.render:ChangeVertexBuffer(this_vs)
  self.other_render:ChangeVertexBuffer(other_vs)
end

function ConnectMeshBehavior:LoadConfig()
  local config = venusjson.LaodJsonFile(self.Config)
  self.edges = config.edges
end

ConnectMeshBehavior:MemberRegister(
  "Other",
  venuscore.ScriptTypes.ReferenceType(
    apolloengine.Node:RTTI(),    
    nil,
    function(thiz, value)
      thiz.Other = value
      thiz.other_render = thiz.Other:GetComponent(apolloengine.Node.CT_RENDER)
    end
  )
)

ConnectMeshBehavior:MemberRegister("Config",
  venuscore.ScriptTypes.FilePathType(
    {"json"},    
    nil,
    function(thiz, value)
      thiz.Config = value
      thiz:LoadConfig()
    end
))

return ConnectMeshBehavior