local venuscore = require "venuscore"
local mathfunction = require "mathfunction"
local apolloengine = require "apolloengine"


local AutoPlay = venuscore.VenusBehavior:extend("Animation_AutoPlay");

local STATE = 
{
  PLAY = 0,
  STOP = 1,
  RESET = 2,
  WAIT = 3
};

function AutoPlay:new()
  self.Delay = 0;
  self.assets = {}
  self._BeginTime = 0.0;
  self._State = STATE.STOP;
 
end

function AutoPlay:_Find(ct)
  if self.Node:HaveComponent(ct) then
    local com = self.Node:GetComponent(ct);
    table.insert(self.assets, com);
  end
end

function AutoPlay:_Play()
  for _, com in ipairs(self.assets) do
    com:Play()
  end
  self._State = STATE.PLAY;
end

function AutoPlay:_Stop()
  self._EnablePlay = false;
  for _, com in ipairs(self.assets) do
    com:Stop()
  end
  self._State = STATE.STOP;
end

function AutoPlay:_Reset()
  self._BeginTime = venuscore.ITimerSystem:GetTimevalue();
  for _, com in ipairs(self.assets) do
    com:Reset()
  end
  self._State = STATE.RESET;
end

function AutoPlay:_OnAwake()

end

function AutoPlay:_OnStart()
  self:_Find(apolloengine.Node.CT_ANIMATION);
  self:_Find(apolloengine.Node.CT_FRAME_PLAYER);
  self:_Find(apolloengine.Node.CT_PARTICLE);
  self._BeginTime = venuscore.ITimerSystem:GetTimevalue();
end


function AutoPlay:_OnUpdate(timespan)
  self:_AccTime();
end

--时间累积
function AutoPlay:_AccTime()
  if self._State ~= STATE.PLAY then
    if self._State == STATE.STOP then
      self:_Stop();
      local now = venuscore.ITimerSystem:GetTimevalue();
      local span = now - self._BeginTime;
      if span > self.Delay then
        self:_Play();
      end
    elseif self._State == STATE.RESET then
      self._State = STATE.STOP;  --必须下一帧才能真正Stop
    end
  end
end

function AutoPlay:SetDelay(delay)
  if delay < 0.0 then
    delay = 0.0;
  end
  if delay > 3600.0 then
    delay = 3600.0;
  end
  self.Delay = delay;
  self:_Reset();
end

function AutoPlay:GetDelay()
  return self.Delay;
end

AutoPlay:MemberRegister("Delay",
  venuscore.ScriptTypes.FloatType(
    0.0, 3600.0,
    AutoPlay.GetDelay,
    AutoPlay.SetDelay
));


return AutoPlay;