

local ExponentialMovingAverage = {}

function ExponentialMovingAverage:Initialize(...)
  --[[
      rho        -  a numebr rho, exponetial base -> rho ^ k. means there is
                    no explicit window, or the window size is infinite.
      window     -  1-D table, the length of which is the window size, 
                    and the value is weight to be manually set, 1-index refers
                    to the latest time. or...
      rho, wsize -  rho, exponetial base, wsize window size, the window will
                    be calculated automatically
  --]]
  if #{...} == 1 then
    if type(({...})[1]) == "number" then
      self.method = 'inf'
      self.wsize = 0
      self.rho = ({...})[1]
    elseif type(({...})[1]) == "table" then
      for i = 1, #({...})[1] do
        assert(type(({...})[1][i])=="number")
      end
      self.method = 'manual'
      self.wsize = #({...})[1]
      self.weight = ({...})[1]
    else
      print("error: invalid method")
    end
  
  elseif #{...} == 2 then
    assert(type(({...})[1])=="number" and type(({...})[2])=="number")
    self.method = 'auto'
    self.rho, self.wsize = unpack({...})
    self.weight = self:GetExpWeight(self.rho, self.wsize)
    
  else
    print("error: to many input arguments")
  end
  
  self.hist = {}
  self.time = 0
  self.ptr = 0
  self.start_filtering = false
  self.fid = {}
  self.w = {}
  for i = 1, self.wsize do
    self.w[i] = {}
  end  

end

function ExponentialMovingAverage:Update()
  self.time = self.time + 1
  self.ptr = self.ptr + 1
  if self.ptr > self.wsize then
    self.ptr = self.ptr - self.wsize
  end

end

function ExponentialMovingAverage:GetExpWeight(rho, wsize)
  local w = {}
  for i = 1, wsize do
    w[i] = math.pow(rho, i-1)
  end
  return w
end

  
  
function ExponentialMovingAverage:Smooth(fidelity, ...)
  --[[
      fidelity  -   digree of confidence of 2d key points
      ...       -   variables need to be smoothed, the order will
                    be viewed as the only identification, thus DO
                    NOT CHANGE THE SEQUENCE OF VARIABLE LIST!!
  --]]
  
  self:Update()
  
  local r = {}
    
  if self.method == 'inf' then
    if self.time <= 1 then
      self.hist = {...}
    else
      self.hist = self:add(self:mul({...}, self.rho), self:mul(self.hist, 1-self.rho))
    end
    r = self:deep_copy(self.hist)
  end
  
  if self.method == 'manual' or self.method == 'auto' then
    r = self:deep_copy({...})
    if self.time < self.wsize then
      self.hist[self.ptr] = {...}
      self.fid[self.ptr] = fidelity
    else
      self.hist[self.ptr] = {...}
      self.fid[self.ptr] = fidelity
      local sum_w = 0
      local mul_this = 0
      for j = 1, #fidelity do
        sum_w = 0
        for t = 1, self.wsize do          
          mul_this = self.fid[((self.ptr-t)%self.wsize)+1][j] * self.weight[t]
          --mul_this = self.fid[((self.ptr-t)%self.wsize)+1][j]
          self.w[t][j] = mul_this
          sum_w = sum_w + mul_this
        end
        for t = 1, self.wsize do
          self.w[t][j] = self.w[t][j] / sum_w
        end
      end
      
      r = self:mul(self:deep_copy({...}), 0)
      
      for i = 1, #{...} do
        for j = 1, #fidelity do
          for t = 1, self.wsize do
            r[i][j] = self:add(r[i][j], self:mul(self.hist[((self.ptr-t)%self.wsize)+1][i][j], self.w[t][j]))
          end
        end
      end
    end
    self.hist[self.ptr] = self:deep_copy(r)
  end
  
  -- print
  --[[
  for i = 1, 14 do
    print(r[2][i][1], r[2][i][2], r[2][i][3])
  end
  --]]
  return unpack(r)

end

function ExponentialMovingAverage:mul(var, k)
  assert(type(k) == "number")
  if var == nil then
    return nil
  elseif type(var) == "number" then
    return var * k
  elseif type(var) == "table" then
    local result = {}
    for i = 1,#var do
      result[i] = self:mul(var[i], k)
    end
    return result
  else
    print("error: unsupported dtype!")
    return nil
  end

end

function ExponentialMovingAverage:add(var1, var2)
  if var1 == nil or var2 == nil then
    return nil
  elseif type(var1) == "number" and type(var2) == "number" then
    return var1 + var2
  elseif type(var1) == "table" and type(var2) == "number" then
    local result = {}
    for i = 1,#var1 do
      result[i] = self:add(var1[i], var2)
    end
    return result
  elseif type(var1) == "number" and type(var2) == "table" then
    return self:add(var2, var1)
  elseif type(var1) == "table" and type(var2) == "table" then
    assert(#var1 == #var2, "error: size must be agree!")
    local result = {}
    for i = 1,#var1 do
      result[i] = self:add(var1[i], var2[i])
    end
    return result
  else
    print("error: unsupported dtype!")
    return nil
  end
end

function ExponentialMovingAverage:deep_copy(orig)
  local copy
  if type(orig) == "table" then
    copy = {}
    for orig_key, orig_value in next, orig, nil do
      copy[self:deep_copy(orig_key)] = self:deep_copy(orig_value)
    end
    setmetatable(copy, self:deep_copy(getmetatable(orig)))
  else
    copy = orig
  end
  return copy
end


--[[
ema = ExponentialMovingAverage
--ema:Initialize(0.9)
--ema:Initialize({7,2,1})
ema:Initialize(0.9, 3)
a = {{{1,1}},{{2,2}},{{3.9,1.3}},{{4,4}},{{2,0}},{{6,6}}}
fid = {{1},{0.7},{0.1},{0.9},{0.1},{1}}
for i = 1,#a do
  smoothed = ema:Smooth(fid[i],a[i])
  print(smoothed[1][1], smoothed[1][2])
end
--]]
return ExponentialMovingAverage