local nodeutility = require "apolloutility.nodeutility"
local apollonode = require "apolloutility.apollonode"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"
local epnp = require "avatar.bodypnp"
require "venusdebug"
require "utility"


local avatartest = {}


function avatartest:Initialize(maincamera)
  self.direct = apollonode.LightNode(apolloengine.LightComponent.LT_DIRECTIONAL);
  self.direct:SetColor(
    mathfunction.vector3(1,1,1));
  self.direct:SetLocalDirection(
    mathfunction.vector3(0,-1,-1));
  
  self.maincamera = maincamera;
  
  epnp:Initialize(epnp.male, maincamera);
  
  self.render = apollonode.ModelNode();
  self.render:CreateResource("comm:documents/model/male");

  return true;
end

local i = 0;
function avatartest:Update(def)
  
  local posrot, point2d = epnp:Update(0, 0, 0);
  self.render:SetLocalPosition(posrot.position);
  self.render:SetLocalRotation(posrot.rotation);
  
  local ls = self.render:GetJoint("m_avg_L_Shoulder");
  local rs = self.render:GetJoint("m_avg_R_Shoulder");
  local lh = self.render:GetJoint("m_avg_L_Hip");
  local rh = self.render:GetJoint("m_avg_R_Hip");
  
  local vp = self.maincamera:GetViewProj();
  
  local wpos = {}
  table.insert(wpos, ls:GetWorldPosition() * vp);
  table.insert(wpos, rs:GetWorldPosition() * vp);
  table.insert(wpos, lh:GetWorldPosition() * vp);
  table.insert(wpos, rh:GetWorldPosition() * vp);
  
  local realres = apolloengine.Framework:GetResolution();
  local spos = {}
  for _, wp in ipairs(wpos) do
    local sp = {
      realres:x() * (wp:x() * 0.5 + 0.5),
      realres:y() * (wp:y() * 0.5 + 0.5)};
    table.insert(spos, sp);
  end
  
  local i = 1;
  for name, ogi in pairs(point2d) do    
    local gus = spos[i];
    --LOG(name.." point 2d x:"..tostring(ogi[1]).." y:"..tostring(ogi[2]).." pnp 2d x:"..tostring(gus[1]).." y:"..tostring(gus[2]));
    LOG(name.." point 2d diff x:"..tostring(ogi[1] - gus[1]).." y:"..tostring(ogi[2] - gus[2]));
    i = i + 1;
  end
  LOG("-------------------------------------")
end


return avatartest;