local mathfunction = require "mathfunction"
local apolloengine = require "apolloengine"


local emptyimage = {}

function emptyimage:Initialize()
  self.texturestream = apolloengine.TextureStream();
  self.texturestream:SetStreamType(
    mathfunction.vector2(4,1),
    apolloengine.TextureEntity.PF_R8G8B8A8);
  for u=1, 4 do
    self.texturestream:SetPixel(u, 1, mathfunction.vector4(0,0,0,0));
  end

  self.emptyimage = apolloengine.TextureEntity();
  self.emptyimage:PushMetadata(
  apolloengine.TextureBufferMetadata(
    apolloengine.TextureEntity.TU_WRITE,
    1, false,
    apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
    apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
    apolloengine.TextureEntity.TF_LINEAR,
    apolloengine.TextureEntity.TF_LINEAR,
    self.texturestream));
  self.emptyimage:CreateResource();
end

function emptyimage:GetImage()
  return self.emptyimage;
end

return emptyimage;