

#SHADER_DEFINE ScaleConstIn

	FUNCTION_INPUT = 
	{
	}
	FUNCTION_OUTPUT =
	{
    { SCALE_EASING_VALUE,           MEDIUM, FLOAT,  "scale_out_EasingV"},
	}

#SHADER_CODE	
    float scale_out_EasingV = 0.0;
#END_CODE
#END_DEFINE

#SHADER_DEFINE ScaleConstOut

	FUNCTION_INPUT = 
	{
	}
	FUNCTION_OUTPUT =
	{
    { SCALE_EASING_VALUE,           MEDIUM, FLOAT,  "scale_out_EasingV"},
	}

#SHADER_CODE	
    float scale_out_EasingV = 0.0;
#END_CODE
#END_DEFINE

#SHADER_DEFINE ScaleLinearIn

	FUNCTION_INPUT = 
	{
		{ EASING_PROGRESS, 		MEDIUM,	FLOAT,	"in_Progress" },
	}
	FUNCTION_OUTPUT =
	{
    { SCALE_EASING_VALUE,           MEDIUM, FLOAT,  "scale_out_EasingV"},
	}

#SHADER_CODE	
    float scale_out_EasingV = in_Progress;
#END_CODE
#END_DEFINE

#SHADER_DEFINE ScaleLinearOut

	FUNCTION_INPUT = 
	{
		{ EASING_PROGRESS, 		MEDIUM,	FLOAT,	"in_Progress" },
	}
	FUNCTION_OUTPUT =
	{
    { SCALE_EASING_VALUE,           MEDIUM, FLOAT,  "scale_out_EasingV"},
	}

#SHADER_CODE	
    float scale_out_EasingV = in_Progress;
#END_CODE
#END_DEFINE


#SHADER_DEFINE ScaleSineIn

	FUNCTION_INPUT = 
	{
		{ EASING_PROGRESS, 		MEDIUM,	FLOAT,	"in_Progress" },
	}
	FUNCTION_OUTPUT =
	{
    { SCALE_EASING_VALUE,           MEDIUM, FLOAT,  "scale_out_EasingV"},
	}

#SHADER_CODE	
    float scale_out_EasingV = sin((in_Progress - 1.0) * 1.5707963267948966) + 1.0;
#END_CODE
#END_DEFINE

#SHADER_DEFINE ScaleSineOut

	FUNCTION_INPUT = 
	{
		{ EASING_PROGRESS, 		MEDIUM,	FLOAT,	"in_Progress" },
	}
	FUNCTION_OUTPUT =
	{
    { SCALE_EASING_VALUE,           MEDIUM, FLOAT,  "scale_out_EasingV"},
	}

#SHADER_CODE	
    float scale_out_EasingV = sin(in_Progress * 1.5707963267948966);
#END_CODE
#END_DEFINE


#SHADER_DEFINE ScaleExponentialIn

	FUNCTION_INPUT = 
	{
		{ EASING_PROGRESS, 		MEDIUM,	FLOAT,	"in_Progress" },
	}
	FUNCTION_OUTPUT =
	{
    { SCALE_EASING_VALUE,           MEDIUM, FLOAT,  "scale_out_EasingV"},
	}

#SHADER_CODE	

  float scale_out_EasingV = 0.0;
  if (in_Progress == 0.0)
    scale_out_EasingV = in_Progress;
  else
    scale_out_EasingV = pow(2.0,10.0 * (in_Progress - 1.0));
#END_CODE
#END_DEFINE

#SHADER_DEFINE ScaleExponentialOut

	FUNCTION_INPUT = 
	{
		{ EASING_PROGRESS, 		MEDIUM,	FLOAT,	"in_Progress" },
	}
	FUNCTION_OUTPUT =
	{
    { SCALE_EASING_VALUE,           MEDIUM, FLOAT,  "scale_out_EasingV"},
	}

#SHADER_CODE	
  float scale_out_EasingV = 0.0;
  if (in_Progress == 1.0)
    scale_out_EasingV = in_Progress;
  else
    scale_out_EasingV = 1.0 - pow(2.0, -10.0 * in_Progress);
#END_CODE
#END_DEFINE


#SHADER_DEFINE ScaleBackIn

	FUNCTION_INPUT = 
	{
		{ EASING_PROGRESS, 		MEDIUM,	FLOAT,	"in_Progress" },
	}
	FUNCTION_OUTPUT =
	{
    { SCALE_EASING_VALUE,           MEDIUM, FLOAT,  "scale_out_EasingV"},
	}

#SHADER_CODE	
  float scale_out_EasingV = pow(in_Progress,3.0) - in_Progress * sin(in_Progress * 3.141592653589793);
#END_CODE
#END_DEFINE

#SHADER_DEFINE ScaleBackOut

	FUNCTION_INPUT = 
	{
		{ EASING_PROGRESS, 		MEDIUM,	FLOAT,	"in_Progress" },
	}
	FUNCTION_OUTPUT =
	{
    { SCALE_EASING_VALUE,           MEDIUM, FLOAT,  "scale_out_EasingV"},
	}

#SHADER_CODE	
  float f_scalebackout = 1.0 - in_Progress;
  float scale_out_EasingV = 1.0 - (pow(f_scalebackout, 3.0) - f_scalebackout * sin(f_scalebackout * 3.141592653589793));
#END_CODE
#END_DEFINE

#SHADER_DEFINE ScaleBounceOut

	FUNCTION_INPUT = 
	{
		{ EASING_PROGRESS, 		MEDIUM,	FLOAT,	"in_Progress" },
	}
	FUNCTION_OUTPUT =
	{
    { SCALE_EASING_VALUE,           MEDIUM, FLOAT,  "scale_out_EasingV"},
	}

#SHADER_CODE	
  const float a_scalebout = 4.0 / 11.0;
  const float b_scalebout = 8.0 / 11.0;
  const float c_scalebout = 9.0 / 10.0;

  const float ca_scalebout = 4356.0 / 361.0;
  const float cb_scalebout = 35442.0 / 1805.0;
  const float cc_scalebout = 16061.0 / 1805.0;

  float t2_scalebout = in_Progress * in_Progress;
  
  float scale_out_EasingV = 0.0;
  if (in_Progress < a_scalebout)
  {
    scale_out_EasingV = 7.5625 * t2_scalebout;
  }
  else
  {
    if (in_Progress < b_scalebout)
    {
      scale_out_EasingV = 9.075 * t2_scalebout - 9.9 * in_Progress + 3.4;
    }
    else
    {
      if (in_Progress < c_scalebout)
      {
        scale_out_EasingV = ca_scalebout * t2_scalebout - cb_scalebout * in_Progress + cc_scalebout;
      }
      else
      {
        scale_out_EasingV = 10.8 * in_Progress * in_Progress - 20.52 * in_Progress + 10.72;
      }
    }
  }

#END_CODE
#END_DEFINE

#SHADER_DEFINE ScaleBounceIn

	FUNCTION_INPUT = 
	{
		{ EASING_PROGRESS, 		MEDIUM,	FLOAT,	"in_Progress" },
	}
	FUNCTION_OUTPUT =
	{
    { SCALE_EASING_VALUE,           MEDIUM, FLOAT,  "scale_out_EasingV"},
	}

#SHADER_CODE	

  float t_scalebin = 1.0 - in_Progress;
  const float a_scalebin = 4.0 / 11.0;
  const float b_scalebin = 8.0 / 11.0;
  const float c_scalebin = 9.0 / 10.0;

  const float ca_scalebin = 4356.0 / 361.0;
  const float cb_scalebin = 35442.0 / 1805.0;
  const float cc_scalebin = 16061.0 / 1805.0;

  float t2_scalebin = t_scalebin * t_scalebin;
  
  float scale_out_EasingV = 0.0;
  if (t_scalebin < a_scalebin)
  {
    scale_out_EasingV = 7.5625 * t2_scalebin;
  }
  else
  {
    if (t_scalebin < b_scalebin)
    {
      scale_out_EasingV = 9.075 * t2_scalebin - 9.9 * t_scalebin + 3.4;
    }
    else
    {
      if (t_scalebin < c_scalebin)
      {
        scale_out_EasingV = ca_scalebin * t2_scalebin - cb_scalebin * t_scalebin + cc_scalebin;
      }
      else
      {
        scale_out_EasingV = 10.8 * t_scalebin * t_scalebin - 20.52 * t_scalebin + 10.72;
      }
    }
  }
  scale_out_EasingV = 1.0 - scale_out_EasingV;

#END_CODE
#END_DEFINE



