#DEFPARAMS
UNIFORM_LEFT_EYE = {"UNIFORM_LEFT_EYE", VEC2, "1.0,1.0"},
UNIFORM_RIGHT_EYE = {"UNIFORM_RIGHT_EYE", VEC2, "1.0,1.0"},
UNIFORM_ROUNDEYE_RADIUS = {"UNIFORM_ROUNDEYE_RADIUS", VEC2, "1.0,1.0"},
UNIFORM_ROUNDEYE_EYECOEF = {"UNIFORM_ROUNDEYE_EYECOEF", FLOAT, "1.0"},
UNIFORM_RATIOASPECT = {"UNIFORM_RATIOASPECT", FLOAT, "1.0"},
UNIFORM_FACECOEF = {"UNIFORM_FACECOEF", VEC2, "1.0,1.0"},
UNIFORM_CHINCOEF = {"UNIFORM_CHINCOEF", FLOAT, "1.0"},
UNIFORM_NOSECOEF = {"UNIFORM_NOSECOEF", FLOAT, "1.0"},
UNIFORM_MOUTHCOEF = {"UNIFORM_MOUTHCOEF", FLOAT, "1.0"},
UNIFORM_EYECOEF = {"UNIFORM_EYECOEF", FLOAT, "1.0"},
UNIFORM_NOSELENGTH_COEF = {"UNIFORM_NOSELENGTH_COEF", FLOAT, "1.0"},
UNIFORM_HAIRLINECOEF = {"UNIFORM_HAIRLINECOEF", FLOAT, "1.0"},
UNIFORM_INNERCANTHUS_COEF = {"UNIFORM_INNERCANTHUS_COEF", FLOAT, "1.0"},
UNIFORM_OUTERCANTHUS_COEF = {"UNIFORM_OUTERCANTHUS_COEF", FLOAT, "1.0"},
UNIFORM_PHILTRUMCOEF = {"UNIFORM_PHILTRUMCOEF", FLOAT, "1.0"},
#END

#DEFTAG
ShaderName = "biggereyes"
RenderQueue = "Overlay"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF, DEPTH_FUNCTION_LESS }
STENCIL_MODE = {STENCIL_OFF}

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 in_Position : POSITION;
	float2 in_Coordinate : TEXCOORD0;
};

struct v2f
{
	float2 out_Coordinate : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

float2 UNIFORM_LEFT_EYE;
float2 UNIFORM_RIGHT_EYE;
float2 EYESCALE_PARAM[2];
float2 UNIFORM_ROUNDEYE_RADIUS;
float UNIFORM_ROUNDEYE_EYECOEF;

float2 EYECORNERPOINTS[8];

float  UNIFORM_RATIOASPECT;
float4 UNIFORM_PTS[30];
float2 UNIFORM_PTS_MASK[30];
float2 UNIFORM_FACECOEF;
float2 FACEPARA[30];
float2 FACEPARARADIUS[30];

float UNIFORM_NOSECOEF;
float UNIFORM_MOUTHCOEF;
float UNIFORM_EYECOEF;
float3x3 UNIFORM_ZOOMSCALE;
float2 NOSEPARAMS[4];
float4 NOSEPOINTS[4];
float2 MOUTHPARAMS[2];
float2 MOUTHPARAMSMINUS[2];
float2 MOUTHPOINTS[4];
float2 MOUTHTRIANGLEPOINTSOUECE[30];
float2 MOUTHTRIANGLEPOINTTARGET[30];
float3 MOUTHTRIANGLES[47];
float2 UNIFORM_EYEAD_LEFT_FROM[16];
float2 UNIFORM_EYEAD_LEFT_TO[16];
float2 UNIFORM_EYEAD_RIGHT_FROM[16];
float2 UNIFORM_EYEAD_RIGHT_TO[16];
float3 UNIFORM_EYEAD_TRIANGLE[22];

float UNIFORM_CHINCOEF;
float4 CHINPOINTS[9];
float2 CHINPARA[9];
float2 CHINPARARADIUS[9];

float UNIFORM_PHILTRUMCOEF;
float2 PHILTRUMPARAMS[4];
float4 PHILTRUMPOINTS[4];
float UNIFORM_HAIRLINECOEF;
float4 HAIRLINEPOINTS[9];
float2 HAIRLINEPARA[9];
float2 HAIRLINEPARARADIUS[9];

float4 UNIFORM_NOSELENGTH_PTS[9];
float UNIFORM_NOSELENGTH_COEF;
float2 NOSELENGTH_PARAM[9];
float2 NOSELENGTH_PARAMRADIUS[9];

float4 UNIFORM_INNERCANTHUS_PTS[2];
float UNIFORM_INNERCANTHUS_COEF;
float2 INNERCANTHUS_PARAM[2];
float2 INNERCANTHUS_PARAMRADIUS[2];

float4 UNIFORM_OUTERCANTHUS_PTS[6];
float UNIFORM_OUTERCANTHUS_COEF;
float UNIFORM_OUTERCANTHUS_FALLOFF;
float2 UNIFORM_OUTERCANTHUS_REF[2];
float2 OUTERCANTHUS_PARAM[6];
float2 OUTERCANTHUS_PARAMRADIUS[6];

float UNIFORM_EYEBROWCOEF;
float UNIFORM_LIPCOEF;
float UNIFORM_EYEADCOEF;
float4 EYEBROWPOINTS[4];
float2 EYEBROWPARA[4];
float2 EYEBROWPARARADIUS[4];

float2 transformWarpPositionToUseByFactor(float2 currentPoint, float2 src, float2 dst, float2 face_dir, float radiusFactor, float deltaFactorX, float deltaFactorY, float aspectRatio)
{
    float deltaFactor = sqrt(deltaFactorX * deltaFactorX + deltaFactorY * deltaFactorY * aspectRatio * aspectRatio);
    float2 currentPointToUse = float2(currentPoint.x, currentPoint.y * aspectRatio);
    float2 srcToUse = float2(src.x, src.y * aspectRatio);
    float2 dstToUse = float2(dst.x, dst.y * aspectRatio);

    float2  rvec = currentPointToUse - srcToUse;
    float rdot = dot(rvec, rvec);

	float aspectRatio_ref = 1.765;
    float2  dir    = dstToUse - srcToUse; dir.y = dir.y / aspectRatio_ref;
    float dirDot = dot(dir, dir);
    float radiusSquare = radiusFactor * radiusFactor * dirDot;

    if(rdot > radiusSquare)
    {
        return currentPoint;
    }

    float r = sqrt(rdot);

    float dirLen = sqrt(dirDot);
    dir = dir / dirLen;

    float dist  = radiusSquare - rdot;
    float delta = deltaFactor * dirLen;
    float tmp = r - delta;
    float alpha = dist / (dist + tmp * tmp);
    alpha = alpha * alpha;

	float2 dir_face_x = dot(dir, face_dir) * face_dir;
	float2 dir_face_y = dir - dir_face_x;
	float2 displace_x =  - (alpha * delta / (deltaFactor + 0.0001) * deltaFactorX) * dir_face_x;
	float2 displace_y =  - (alpha * delta / (deltaFactor + 0.0001) * deltaFactorY) * dir_face_y;
	float2 positionToUse;
	positionToUse.x = currentPointToUse.x + displace_x.x + displace_y.x;
	positionToUse.y = currentPoint.y + (displace_x.y + displace_y.y) / aspectRatio * aspectRatio_ref;
    return positionToUse;
}

float2 scaleWarpPositionToUse(float2 centerPostion, float2 currentPosition, float radius, float scaleRatio, float aspectRatio)
{

    float2 currentPositionToUse = float2(currentPosition.x, currentPosition.y * aspectRatio);
    float2 centerPostionToUse = float2(centerPostion.x, centerPostion.y * aspectRatio);

    float2  rvec = currentPositionToUse - centerPostionToUse;
    float rdot = dot(rvec, rvec);

    float radius_square = radius * radius;
    if(rdot > radius_square)
    {
        return currentPosition;
    }

    float r = sqrt(rdot);
    float factor = r / radius - 1.0;
    float alpha = 1.0 - scaleRatio * factor * factor;
    float2 positionToUse = centerPostion + alpha * (currentPosition - centerPostion);

    return positionToUse;
}

// R the max radius, r the reference inner radius, ellipse_alpha is a/b for ellipse, face_dir_x is the direction vector for x of face

float2 warpObliqueEllipseScalePositionToUse(float2 center, float2 p, float2 face_dir_x, float r, float R, float inten, float ratio, float ellipse_alpha)
{
    // cos(agnle) = face_dir.x; sin(angle) = - face_dir.y;
    float2 face_dir_y = float2(-face_dir_x.y, face_dir_x.x);
    float2 m_point = p;
    float2 p_u = float2(p.x, p.y * ratio + 0.5 - 0.5 * ratio * ellipse_alpha);
    float2 c_u = float2(center.x, center.y * ratio + 0.5 - 0.5 * ratio * ellipse_alpha);
    float2 vec_pc = p_u - c_u;
    float2  p_r = float2(dot(vec_pc, face_dir_x), dot(vec_pc, face_dir_y));

    float d = sqrt(p_r.x * p_r.x + p_r.y * p_r.y * ellipse_alpha * ellipse_alpha);
    float scale = (R - r) / r * inten;
    float r_m = r * (1.0 + scale);
    if (d < r_m)
    {
        float alpha = 1.0 / (1.0 + scale);
        m_point = center + (p - center) * alpha;
    }
    else if (d < R)
    {
        float percent = (R - d) / (R - r_m);
        m_point = center + (p - center) * (R - percent * (R - r)) / d;
    }
	return m_point;
}

// solve for barycentric coordinate for p_cur in triangle {px, py}
float3 solveBarycentricWeight(float3 px, float3 py, float2 p_cur)
{
    float delta = 0.00001;
    float4 o1 = float4(px.x, px.y, px.z, p_cur.x);
    float4 o2 = float4(py.x, py.y, py.z, p_cur.y);
    float4 o3 = float4(1.0, 1.0, 1.0, 1.0);
    if(abs(o1.x) < delta)
        o1 = o1 + o3;
    o1 = o1 / o1.x;
    o2 = o2 - o2.x * o1;
    o3 = o3 - o1;
    if(abs(o2.y) < delta)
    {
        if(abs(o3.y) < delta)
        {
            if(abs(o2.z) < delta)
                return float3(1, 0, 0);
            else
                return float3(o1.w, 0, o2.w / o2.z);
        }
        else
        {
            float4 o_temp = o2;
            o2 = o3;
            o3 = o_temp;
        }
    }
    o2 = o2 / o2.y;
    o3 = o3 - o2 * o3.y;
    if(abs(o3.z) > delta)
    {
        o3 = o3 / o3.z;
    }
    else
    {
        o3.w = 0.0;
    }
    o3 = o3 / o3.z;
    o2 = o2 - o3 * o2.z;
    o1 = o1 - o2 * o1.y - o3 * o1.z;
    return float3(o1.w, o2.w, o3.w);
}

// warp by triangle texture mapping
float2 warpByTriangle(float2 origin[3], float2 target[3], float2 p)
{
    float3 px = float3(origin[0].x, origin[1].x, origin[2].x);
    float3 py = float3(origin[0].y, origin[1].y, origin[2].y);

    float i1 = (origin[1].y - origin[0].y) * (origin[2].x - origin[0].x) - (origin[1].x - origin[0].x) * (origin[2].y - origin[0].y);
    float i2 = (origin[2].y - origin[1].y) * (origin[0].x - origin[1].x) - (origin[2].x - origin[1].x) * (origin[0].y - origin[1].y);
    float i3 = (origin[0].y - origin[2].y) * (origin[1].x - origin[2].x) - (origin[0].x - origin[2].x) * (origin[1].y - origin[2].y);
    float j1 = (origin[1].y - origin[0].y) * (p.x - origin[0].x) - (origin[1].x - origin[0].x) * (p.y - origin[0].y);
    float j2 = (origin[2].y - origin[1].y) * (p.x - origin[1].x) - (origin[2].x - origin[1].x) * (p.y - origin[1].y);
    float j3 = (origin[0].y - origin[2].y) * (p.x - origin[2].x) - (origin[0].x - origin[2].x) * (p.y - origin[2].y);

    float2 res_p = p;
    if(i1 * j1 >= 0.0 && i2 * j2 >= 0.0 && i3 * j3 >= 0.0)
    {
        float3 weight = solveBarycentricWeight(px, py, p);
        res_p = target[0] * weight.x + target[1] * weight.y + target[2] * weight.z;
    }
    return res_p;
}

v2f vert(appdata v)
{
#define pointArray UNIFORM_PTS
#define pointMask UNIFORM_PTS_MASK
#define facepara FACEPARA
#define facepararadius FACEPARARADIUS

#define eyescaleparam EYESCALE_PARAM

#define noselengthPoints UNIFORM_NOSELENGTH_PTS
#define noselengthParam NOSELENGTH_PARAM
#define noselengthParamRadius NOSELENGTH_PARAMRADIUS

#define nosepoints NOSEPOINTS
#define noseparam NOSEPARAMS
#define mouthpoints MOUTHPOINTS
#define eyecornerpoints EYECORNERPOINTS
#define mouthparam MOUTHPARAMS
#define mouthparamminus MOUTHPARAMSMINUS

#define mouth_tri_src MOUTHTRIANGLEPOINTSOUECE
#define mouth_tri_tar MOUTHTRIANGLEPOINTTARGET
#define mouthtriangles MOUTHTRIANGLES
#define eyead_left_from UNIFORM_EYEAD_LEFT_FROM
#define eyead_left_to UNIFORM_EYEAD_LEFT_TO
#define eyead_right_from UNIFORM_EYEAD_RIGHT_FROM
#define eyead_right_to UNIFORM_EYEAD_RIGHT_TO
#define eyead_triangles UNIFORM_EYEAD_TRIANGLE
#define chinpara CHINPARA
#define chinpararadius CHINPARARADIUS
#define chinpoints CHINPOINTS

#define philtrumparam PHILTRUMPARAMS
#define philtrumpoints PHILTRUMPOINTS

#define hairlinepara HAIRLINEPARA
#define hairlinepararadius  HAIRLINEPARARADIUS
#define hairlinepoints HAIRLINEPOINTS

#define innercanthusPoints UNIFORM_INNERCANTHUS_PTS
#define innercanthusParam INNERCANTHUS_PARAM
#define innercanthusParamRadius INNERCANTHUS_PARAMRADIUS

#define outercanthusPoints UNIFORM_OUTERCANTHUS_PTS
#define outercanthusParam OUTERCANTHUS_PARAM
#define outercanthusParamRadius OUTERCANTHUS_PARAMRADIUS
#define outercanthusRef UNIFORM_OUTERCANTHUS_REF

#define eyebrowpara EYEBROWPARA
#define eyebrowpararadius EYEBROWPARARADIUS
#define eyebrowpoints EYEBROWPOINTS

  float4 in_Position = v.in_Position;
  float2 in_TexCooridate = v.in_Coordinate;
  float2 leftEyeCenterPosition = UNIFORM_LEFT_EYE;
  float2 rightEyeCenterPosition = UNIFORM_RIGHT_EYE;

  float2 roundeyeRadius = UNIFORM_ROUNDEYE_RADIUS;
  float roundeyeCoef = UNIFORM_ROUNDEYE_EYECOEF;

  float aspectRatio = UNIFORM_RATIOASPECT;
  float2 faceCoef = UNIFORM_FACECOEF;
  float noseCoef = UNIFORM_NOSECOEF;
  float mouthCoef = UNIFORM_MOUTHCOEF;
  float noselengthCoef = UNIFORM_NOSELENGTH_COEF;
	float chinCoef = UNIFORM_CHINCOEF;
	float philtrumCoef = UNIFORM_PHILTRUMCOEF;
  float hairlineCoef = UNIFORM_HAIRLINECOEF;
  float innercanthusCoef = UNIFORM_INNERCANTHUS_COEF;
  float outercanthusCoef = UNIFORM_OUTERCANTHUS_COEF * UNIFORM_OUTERCANTHUS_FALLOFF;
	float outercanthusFallOff = UNIFORM_OUTERCANTHUS_FALLOFF;
	float eyebrowCoef = UNIFORM_EYEBROWCOEF;
  float lipCoef = UNIFORM_LIPCOEF;
  float eyeadcoef = UNIFORM_EYEADCOEF;
  float eyecoef = UNIFORM_EYECOEF;
  float3x3 zoomscale = UNIFORM_ZOOMSCALE;

  float2 newpos = (mul(float3(in_Position.xy,1.0), transpose(zoomscale))).xy;
  float4 outPos = float4(newpos,in_Position.z,in_Position.a);

  float2 newTexCooridate = float2((newpos.x+1.0)*0.5,(newpos.y+1.0)*0.5);
  const int pointNum = 30;
  float delta = 0.00001;
  float2 positionToUse  = newTexCooridate * 2.0 - 1.0;

  float2 face_dir = rightEyeCenterPosition - leftEyeCenterPosition;
  face_dir = float2(face_dir.x, face_dir.y * aspectRatio);
  face_dir = face_dir / sqrt(dot(face_dir, face_dir));

//   const int mouth_triangle_num = 1;
  const int mouth_triangle_num = 47;
  const float threshold = 0.001;

  float2 displacement = float2(0, 0);
  float2 new_position_single;

  if(abs(lipCoef) > threshold)
  {
    for(int i = 0 ; i < mouth_triangle_num; i ++)
    {
      int tri_index_1 = int(mouthtriangles[i].x);
      int tri_index_2 = int(mouthtriangles[i].y);
      int tri_index_3 = int(mouthtriangles[i].z);
      float2 vert_src[3] = {mouth_tri_src[tri_index_1], mouth_tri_src[tri_index_2], mouth_tri_src[tri_index_3]};
      float2 vert_tar[3] = {mouth_tri_tar[tri_index_1], mouth_tri_tar[tri_index_2], mouth_tri_tar[tri_index_3]};
      new_position_single = warpByTriangle(vert_tar, vert_src, positionToUse);
      displacement = displacement + new_position_single - positionToUse;
    }
  }

  if(abs(eyeadcoef) > threshold)
  {
    const int eyead_triangle_num = 22;
    for(int i = 0 ; i < eyead_triangle_num; i ++)
    {
      int tri_index_1 = int(eyead_triangles[i].x);
      int tri_index_2 = int(eyead_triangles[i].y);
      int tri_index_3 = int(eyead_triangles[i].z);

      float2 left_src[3] = {eyead_left_from[tri_index_1], eyead_left_from[tri_index_2], eyead_left_from[tri_index_3]};
      float2 left_tar[3] = {eyead_left_to[tri_index_1], eyead_left_to[tri_index_2], eyead_left_to[tri_index_3]};
      new_position_single = warpByTriangle(left_tar, left_src, positionToUse);
      displacement = displacement + new_position_single - positionToUse;
      float2 right_src[3] = {eyead_right_from[tri_index_1], eyead_right_from[tri_index_2], eyead_right_from[tri_index_3]};
      float2 right_tar[3] = {eyead_right_to[tri_index_1], eyead_right_to[tri_index_2], eyead_right_to[tri_index_3]};
      new_position_single = warpByTriangle(right_tar, right_src, positionToUse);
      displacement = displacement + new_position_single - positionToUse;
    }
  }


	//眼睛
  if(eyecoef > threshold)
  {
	  for(int j = 0; j < 2; j=j+1)
	  {
		  float2 px = eyecornerpoints[j*4+3] - eyecornerpoints[j*4+2];
		  float2 py = eyecornerpoints[j*4] - eyecornerpoints[j*4+1];
		  float ea = sqrt(dot(px, px)) / sqrt(dot(py, py)) / aspectRatio;
      if(ea < 0.6) ea = 0.6;
      if(ea > 3) ea = 3;
			ea = ea / eyescaleparam[1].y;
		  float r =sqrt(dot(px, px))*aspectRatio;
		  float r1 = r * eyescaleparam[0].y;
		  float R1 = r * eyescaleparam[0].x;
			float inten = eyescaleparam[1].x * eyecoef;

			float2 eye_border = eyecornerpoints[j*4+3];
		  float2 eye_center = (eyecornerpoints[j*4] + eyecornerpoints[j*4+1] + eyecornerpoints[j*4+2] + eyecornerpoints[j*4+3]) / 4;
		  new_position_single = warpObliqueEllipseScalePositionToUse(eye_center, positionToUse, face_dir, r1, R1, inten, aspectRatio, ea);

			float2 point_dir = eye_border - positionToUse;
      point_dir = float2(point_dir.x, point_dir.y * aspectRatio);

			float2 contour_dir;
			if (j == 0) contour_dir = eye_border - pointArray[2].xy;
			else contour_dir = eye_border - pointArray[3].xy;
			contour_dir = float2(contour_dir.x, contour_dir.y * aspectRatio);
			float d = sqrt(dot(contour_dir, contour_dir));
      contour_dir = contour_dir / d;

			float2 m_displacement = new_position_single - positionToUse;
			float dir_dot_k = 1 - dot(contour_dir, point_dir) / (d * 0.9);
			if (dir_dot_k < 0) dir_dot_k = 0;
			if (dir_dot_k < 1) m_displacement = m_displacement * dir_dot_k;

		  displacement = displacement + m_displacement;
	  }
  }

  // 美颜专项 圆眼
  if(roundeyeCoef > 0)
  {
    new_position_single = scaleWarpPositionToUse(leftEyeCenterPosition,  positionToUse, roundeyeRadius.x, 0.7*roundeyeCoef, aspectRatio);
		displacement = displacement + new_position_single - positionToUse;
		new_position_single = scaleWarpPositionToUse(rightEyeCenterPosition, positionToUse, roundeyeRadius.y, 0.7*roundeyeCoef, aspectRatio);
		displacement = displacement + new_position_single - positionToUse;
  }


	//hairline
  if(hairlineCoef > threshold)
  {
    for (int j = 0; j < 9; j++)
    {
      new_position_single = transformWarpPositionToUseByFactor(positionToUse, hairlinepoints[j].xy, hairlinepoints[j].zw, face_dir, hairlinepararadius[j].x, hairlinepara[j].x * hairlineCoef, hairlinepara[j].y * hairlineCoef, aspectRatio);
		  displacement = displacement + new_position_single - positionToUse;
    }
  }

  //脸

    for(int j = 0; j < pointNum; j=j+1)
    {
	  int k = (int)pointMask[j].x;
	  if(faceCoef[k] > threshold)
      {
        new_position_single = transformWarpPositionToUseByFactor(positionToUse, pointArray[j].xy, pointArray[j].zw, face_dir, facepararadius[j].x, facepara[j].x * faceCoef[k], facepara[j].y * faceCoef[k], aspectRatio);
        displacement = displacement + new_position_single - positionToUse;
      }
    }

	//chin
  if(chinCoef > threshold)
  {
	  for(int j = 0; j < 9; j++)
	  {
	  	new_position_single = transformWarpPositionToUseByFactor(positionToUse, chinpoints[j].xy, chinpoints[j].zw, face_dir, chinpararadius[j].x, chinpara[j].x * chinCoef, chinpara[j].y * chinCoef, aspectRatio);
	  	displacement = displacement + new_position_single - positionToUse;
	  }
  }

  //鼻子
  // noseparam[0].x: moving param, noseparam[0].y: moving radius
  if(noseCoef > threshold)
  {
    for(int j = 0 ; j < 4 ; j ++)
    {
      new_position_single = transformWarpPositionToUseByFactor(positionToUse, nosepoints[j].xy, nosepoints[j].zw, face_dir, noseparam[j].y, noseparam[j].x * noseCoef, 0, aspectRatio);
      displacement = displacement + new_position_single - positionToUse;
    }
  }

  // Noselength
  if(noselengthCoef > threshold)
  {
    for(int j = 0; j < 9 ; j++)
    {
      new_position_single = transformWarpPositionToUseByFactor(positionToUse, noselengthPoints[j].xy, noselengthPoints[j].zw, face_dir, noselengthParamRadius[j].x, noselengthParam[j].x * noselengthCoef, noselengthParam[j].y * noselengthCoef, aspectRatio);
		  displacement = displacement + new_position_single - positionToUse;
    }
  }


  // Innercanthus
  if(innercanthusCoef > threshold)
  {
    for(int j = 0; j < 2 ; j++)
    {
      new_position_single = transformWarpPositionToUseByFactor(positionToUse, innercanthusPoints[j].xy, innercanthusPoints[j].zw, face_dir, innercanthusParamRadius[j].x, - innercanthusParam[j].x * innercanthusCoef, - innercanthusParam[j].y * innercanthusCoef, aspectRatio);
		  displacement = displacement + new_position_single - positionToUse;
    }
  }

	// Outercanthus
  if(outercanthusCoef > threshold)
  {
    float2 eye_center[2];
    eye_center[0] = leftEyeCenterPosition;
    eye_center[1] = rightEyeCenterPosition;
    for(int j = 0; j < 6 ; j++)
    {
      new_position_single = transformWarpPositionToUseByFactor(positionToUse, outercanthusPoints[j].xy, outercanthusPoints[j].zw, face_dir, outercanthusParamRadius[j].x * outercanthusFallOff, - outercanthusParam[j].x * outercanthusCoef, - outercanthusParam[j].y * outercanthusCoef * 5, aspectRatio);
      int eye_ind = 0;
      if(j == 1 || j == 3 || j ==5) eye_ind = 1;  // hlslcc编gles2不支持%运算符

			float2 m_displacement = new_position_single - positionToUse;
      float2 point_canthus_dir = outercanthusPoints[j].xy - positionToUse;
      point_canthus_dir = float2(point_canthus_dir.x, point_canthus_dir.y * aspectRatio);

      float2 canthus_center_dir = outercanthusPoints[j].xy - eye_center[eye_ind];
      canthus_center_dir = float2(canthus_center_dir.x, canthus_center_dir.y * aspectRatio);
      float d = sqrt(dot(canthus_center_dir, canthus_center_dir));
      canthus_center_dir = canthus_center_dir / d;

			float2 py = eyecornerpoints[eye_ind*4] - eyecornerpoints[eye_ind*4+1];
			float r = sqrt(dot(py, py)) / 4;
      float dir_dot_k = 1 - dot(canthus_center_dir, point_canthus_dir) / (d - r);
			if (dir_dot_k < 0) dir_dot_k = 0;
      if (dir_dot_k < 1) m_displacement = m_displacement * dir_dot_k;

			float2 ref_dir = outercanthusPoints[j].xy - outercanthusRef[eye_ind];
			ref_dir = float2(ref_dir.x, ref_dir.y * aspectRatio);
			d = sqrt(dot(ref_dir, ref_dir));
			dir_dot_k = 1 - dot(ref_dir, point_canthus_dir) / (d - r);
			if (dir_dot_k < 0) dir_dot_k = 0;
			if (dir_dot_k < 1) m_displacement = m_displacement * dir_dot_k;

      displacement = displacement + m_displacement;
    }
  }

	//人中
  if(philtrumCoef > threshold)
  {
    for(int j = 0 ; j < 4 ; j ++)
    {
      new_position_single = transformWarpPositionToUseByFactor(positionToUse, philtrumpoints[j].xy, philtrumpoints[j].zw, face_dir, philtrumparam[j].y, 0, philtrumparam[j].x * philtrumCoef, aspectRatio);
			displacement = displacement + new_position_single - positionToUse;
    }
  }
	// eyebrow
  if(abs(eyebrowCoef) > threshold)
  {
    for(int j = 0; j < 4; j++)
	  {
		  new_position_single = transformWarpPositionToUseByFactor(positionToUse, eyebrowpoints[j].xy, eyebrowpoints[j].zw, face_dir, eyebrowpararadius[j].x, eyebrowpara[j].x * eyebrowCoef, eyebrowpara[j].y * eyebrowCoef, aspectRatio);
		  displacement = displacement + new_position_single - positionToUse;
	  }
  }

  //// 嘴
  //// mouthpoints: top, down, left, right
  //// mouthparam: x radius, y radius, x scale, y scale

  if(abs(mouthCoef) > threshold)
  {
    float2 px = mouthpoints[3] - mouthpoints[2];
    float2 py = mouthpoints[0] - mouthpoints[1] + (mouth_tri_tar[10] - mouth_tri_src[10]) * 2;

    float ellipse_alpha, R, r, inten;
    if(mouthCoef > 0)
    {
      ellipse_alpha = sqrt(sqrt(dot(px, px)) / sqrt(dot(py, py)) * mouthparam[1].y);
      R = sqrt(dot(px, px)) * mouthparam[0].x;
      r = sqrt(dot(px, px)) * mouthparam[0].y;
      inten = mouthparam[1].x * mouthCoef;
    }
    else
    {
      mouthCoef = -mouthCoef;
      ellipse_alpha = sqrt(sqrt(dot(px, px)) / sqrt(dot(py, py)) * mouthparamminus[1].y);
      R = sqrt(dot(px, px)) * mouthparamminus[0].x;
      r = sqrt(dot(px, px)) * mouthparamminus[0].y;
      inten = mouthparamminus[1].x * mouthCoef;
    }


    float2 mouth_center = (mouthpoints[0] + mouthpoints[1] + mouthpoints[2] + mouthpoints[3]) / 4;
    new_position_single = warpObliqueEllipseScalePositionToUse(mouth_center, positionToUse, face_dir, r, R, inten, aspectRatio, ellipse_alpha);
    displacement = displacement + new_position_single - positionToUse;
  }

  positionToUse = positionToUse + displacement;
  float2 out_TexCooridate =  0.5 * positionToUse + 0.5;

  v2f o;
  o.vertex = UniformNDC(outPos);
  o.out_Coordinate = float2(out_TexCooridate.x, 1.0 - out_TexCooridate.y);
  return o;
}

Texture2D TEXTURE_DIFFUSE;
SamplerState TEXTURE_DIFFUSE_Sampler;
void frag(in v2f i, out float4 outColor : SV_Target0)
{
	#define inputImageTexture TEXTURE_DIFFUSE
	float2 textureCoordinate = i.out_Coordinate.xy;

	outColor = TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler,float2(clamp(textureCoordinate.x,0.001,0.999),clamp(textureCoordinate.y,0.001,0.999)));
}

ENDCG
#END
