#SHADER_DEFINE FaceCropMouthVertex

	FUNCTION_INPUT = 
	{
		{ ATTRIBUTE_POSITION, 			HIGH,	VEC4,		"in_Position" },
    { ATTRIBUTE_COORDNATE1, 		HIGH,	FLOAT,	 "in_Radius" },
    { UNIFORM_CROPCENTER,	      HIGH,	VEC2,		"in_CropCenter" },
    { UNIFORM_CROPSCALE,	      HIGH,	VEC2,		"in_CropScale" },

	}

	FUNCTION_OUTPUT = 
	{
    { ATTRIBUTE_COORDNATE0,			HIGH,	VEC2,		"out_TexCooridate" },
    { ATTRIBUTE_COORDNATE1, 		HIGH,	FLOAT,		"out_Radius" },

	}

#SHADER_CODE
   
    vec2 out_TexCooridate;
    out_TexCooridate=(vec2(1.0,1.0)+in_Position.xy)/2.0;
    out_TexCooridate.y = 1.0 - out_TexCooridate.y;
    vec2 pos;
    pos = in_CropCenter+(in_Position.xy-in_CropCenter)*in_CropScale;
    //gl_Position =in_Position;
    float out_Radius = in_Radius;
    gl_Position =vec4(pos,0.0,1.0);
#END_CODE
#END_DEFINE


#SHADER_DEFINE FaceCropMouthFragment
	FUNCTION_INPUT = 
	{
    { TEXTURE_DIFFUSE, 		  NONE,	TEXTURE2D,	"in_TextureFace" },
		{ ATTRIBUTE_COORDNATE0,	HIGH,	VEC2,		  "in_TexC" }, 
    { ATTRIBUTE_COORDNATE1, 		HIGH,	FLOAT,		  "in_dis" },
    {UNIFORM_EDGEJUDGE,         HIGH,FLOAT,     "in_edgeJudge"},
    {UNIFORM_EDGEALPHA,         HIGH,VEC3,      "in_edgeAlpha"},
	}
	
#SHADER_CODE

    vec4 bgColor = texture2D(in_TextureFace, in_TexC);
    float disedge = in_edgeJudge;
    if(in_dis<disedge)
    {
       gl_FragColor = bgColor; 
    }
    else
    {
       float alpha = 1.0-(in_dis-disedge)/(1.0-disedge);
       float k = in_edgeAlpha.x;
       float p0y = in_edgeAlpha.y;
       float p2y = in_edgeAlpha.z;
       float alphabe = (1.0-alpha)*(1.0-alpha)*p0y+2.0*alpha*(1.0-alpha)*k+alpha*alpha*p2y;
       gl_FragColor =vec4(bgColor.rgb,alphabe);
  
    }
#END_CODE
#END_DEFINE
