#version 300 es
precision mediump float;

in vec2 texCoord;

uniform mediump sampler2D inputImageTexture;
uniform mediump sampler3D sAffineGridRow0;
uniform mediump sampler3D sAffineGridRow1;
uniform mediump sampler3D sAffineGridRow2;

uniform int enableHdr;

uniform mat3 ccm;
uniform vec3 ccm_bias;
uniform vec3 shifts[16];
uniform vec3 slopes[16];
uniform vec3 mix_weight;
uniform float mix_bias;

layout(location = 0) out vec4 colorOut;


vec3 hdr(vec3 src){
    vec4 rgba = vec4(src, 1.0);
    vec3 new_rgb = src * ccm + ccm_bias;

    vec3 tmp2 = vec3(0.0);
    for (int i = 0; i < 16; ++i) {
        tmp2 += (slopes[i].rgb * max(vec3(0.0), new_rgb - shifts[i].rgb));
    }

    float guide = clamp(dot(tmp2, mix_weight) + mix_bias, 0.0, 1.0);
    vec3 grid = vec3(guide, texCoord.x, texCoord.y);

    vec4 row0 = texture(sAffineGridRow0, grid);
    vec4 row1 = texture(sAffineGridRow1, grid);
    vec4 row2 = texture(sAffineGridRow2, grid);
    vec3 dst = clamp(vec3(dot(row0, rgba), dot(row1, rgba), dot(row2, rgba)), 0.0, 1.0);
    return dst;
}


void main() {
    vec4 src = texture(inputImageTexture, texCoord);
    if(src.a > 0.0) src.rgb /= src.a;
    vec3 dst = src.rgb;
    if(enableHdr > 0){
        dst.rgb = hdr(src.rgb);
    }

    colorOut = vec4(dst.rgb, 1.0) * src.a;
}
