precision highp float;
// varying highp vec2 vTextureCoord;
uniform sampler2D inputImageTexture;
uniform sampler2D inputImageTexture2;
uniform sampler2D inputImageTexture3;

uniform sampler2D inputMask;
varying vec2 uv;

#define uSampler inputImageTexture
#define uv0 uv

uniform int baseTexWidth;
uniform int baseTexHeight;
uniform vec2 maskTexSize;

uniform float intensity1;
uniform float intensity2;
uniform float intensity3;
uniform float intensity4;
uniform float intensity5;
uniform float intensity6;
uniform float intensity7;
uniform float intensity8;

uniform float scaleSize1;//scaleSize对素材图也就是mask图按比例缩放
uniform float scaleSize2;
uniform float scaleSize3;
uniform float scaleSize4;
uniform float scaleSize5;
uniform float scaleSize6;
uniform float scaleSize7;
uniform float scaleSize8;

uniform float pointCount;
uniform vec2 point1;
uniform vec2 point2;
uniform vec2 point3;
uniform vec2 point4;
uniform vec2 point5;
uniform vec2 point6;
uniform vec2 point7;
uniform vec2 point8;

uniform float maskFlag1;
uniform float maskFlag2;
uniform float maskFlag3;
uniform float maskFlag4;
uniform float maskFlag5;
uniform float maskFlag6;
uniform float maskFlag7;
uniform float maskFlag8;

vec4 maskFlagColor = vec4(0.6471, 0.8711, 0.1647, 1.0);

vec4 locationEffect(vec4 baseColor, float gaussDist, float intensity)
{
    float slider_progress = abs(intensity);

    // vec2 uv = vTextureCoord;
//    vec4 curColor = texture2D(uSampler, uv);
    vec4 curColor = baseColor;
    vec4 textureColor = curColor;
    float blueColor = curColor.b * (17.0 - 1.0);
    vec2 standardTableSize = vec2(289.0, 17.0);
    vec2 pixelSize = 1.0 / standardTableSize;
    vec2 quad1 = vec2(0.0);
    quad1.y = floor(floor(blueColor) / 17.0);
    quad1.x = floor(blueColor) - (quad1.y * 1.0);
    vec2 quad2;
    quad2.y = floor(ceil(blueColor) / 17.0);
    quad2.x = ceil(blueColor) - (quad2.y * 1.0);
    vec2 texPos1;
    texPos1.x = (quad1.x * 1.0 / 17.0) + 0.5 / standardTableSize.x + ((1.0 / 17.0 - 1.0 / standardTableSize.x) * textureColor.r);
    texPos1.y = (quad1.y * 1.0 / 1.0) + 0.5 / standardTableSize.y +((1.0 / 1.0 - 1.0 / standardTableSize.y) * textureColor.g);
    //                    "    texPos1.x = 1.0 - texPos1.x;
    //                    "    texPos1.y = 1.0 - texPos1.y;
    vec2 texPos2;
    texPos2.x = (quad2.x * 1.0 / 17.0) + 0.5 / standardTableSize.x + ((1.0 / 17.0 - 1.0 / standardTableSize.x) * textureColor.r);
    texPos2.y = (quad2.y * 1.0 / 1.0) + 0.5 / standardTableSize.y +((1.0 / 1.0 - 1.0 / standardTableSize.y) * textureColor.g);
    //                    "    texPos2.x = 1.0 - texPos2.x;
    //                    "    texPos2.y = 1.0 - texPos2.y;
    float alpha = fract(blueColor);

    vec4 newColor = vec4(0.0);
    if (intensity < 0.0){

        vec4 newColor1 = texture2D(inputImageTexture2, texPos1);
        vec4 newColor2 = texture2D(inputImageTexture2, texPos2);
        newColor = mix(newColor1, newColor2, alpha);

    } else {

        vec4 newColor1 = texture2D(inputImageTexture3, texPos1);
        vec4 newColor2 = texture2D(inputImageTexture3, texPos2);
        newColor = mix(newColor1, newColor2, alpha);
    }

    newColor = mix(curColor,newColor,slider_progress*gaussDist);
    return newColor;
}

vec2 sucaiAlign(vec2 videoUV,vec2 videoSize,vec2 sucaiSize,vec2 anchorImageCoord,float sucaiScale)
{
    vec2 videoImageCoord = videoUV * videoSize;
    vec2 sucaiUV= (videoImageCoord - anchorImageCoord)/(sucaiSize*sucaiScale*2.2) + vec2(0.5);//scaleSize对素材图也就是mask图按比例缩放
    return sucaiUV;
}

vec3 rgb2hsv(vec3 c){
        vec4 K=vec4(0.,-1./3.,2./3.,-1.),
             p=mix(vec4(c.bg ,K.wz),vec4(c.gb,K.xy ),step(c.b,c.g)),
             q=mix(vec4(p.xyw,c.r ),vec4(c.r ,p.yzx),step(p.x,c.r));
        float d=q.x-min(q.w,q.y),
              e=1e-10;
        return vec3(abs(q.z+(q.w-q.y)/(6.*d+e)),d/(q.x+e),q.x);
}
float hsvDistanceOf(vec3 hsv1, vec3 hsv2) {
    float x1 = hsv1.z * hsv1.y * cos(hsv1.x * 2.0 * 3.1415926);
    float y1 = hsv1.z * hsv1.y * sin(hsv1.x * 2.0 * 3.1415926);
    float z1 = 1.4*(1.0 - hsv1.z);
    float x2 = hsv2.z * hsv2.y * cos(hsv2.x * 2.0 * 3.1415926);
    float y2 = hsv2.z * hsv2.y * sin(hsv2.x * 2.0 * 3.1415926);
    float z2 = 1.4*(1.0 - hsv2.z);
    return distance(vec3(x1, y1, z1), vec3(x2, y2, z2));;
}

vec3 rgb2ycbcr(vec3 c){
	float y=.299*c.r+.587*c.g+.114*c.b;
	return vec3(y,(c.b-y)*.565,(c.r-y)*.713);
}

vec4 maskColorFun(sampler2D sucai, vec4 baseColor,vec2 videoSize,vec2 sucaiSize,vec2 anchorImageCoord,float sucaiScale, vec2 anchorPoint, float accurIntensity, float maskFlagVal)
{
    lowp vec4 resultColor = baseColor;
    vec2 sucaiUV = sucaiAlign(uv0,videoSize,sucaiSize,anchorImageCoord,sucaiScale);
    lowp vec4 maskColor = texture2D(sucai,sucaiUV);
    vec3 srcAnchor = texture2D(inputImageTexture, anchorPoint).rgb;
    
    // vec3 baseColor_hsv = rgb2ycbcr(baseColor.rgb);
    // vec3 srcAnchor_hsv = rgb2ycbcr(srcAnchor);
    // float diff = distance(baseColor_hsv, srcAnchor_hsv);
    // float realDist = clamp(diff*(3.0), 0.0, 1.0);

    // vec3 baseColor_hsv = rgb2hsv(baseColor.rgb);
    // vec3 srcAnchor_hsv = rgb2hsv(srcAnchor);
    // float diff = hsvDistanceOf(baseColor_hsv, srcAnchor_hsv);
    // float realDist = clamp(diff*(1.6), 0.0, 1.0);
        
    float diff = distance(baseColor.rgb, srcAnchor);
    float realDist = clamp(diff*(1.0), 0.0, 1.0);
    realDist = (1.0 - realDist) * maskColor.a * maskFlagVal;

    resultColor = mix(baseColor, maskFlagColor, realDist);
    return resultColor;
}


void main(void)
{
    vec2 baseTexureSize = vec2(baseTexWidth,baseTexHeight);
//    vec2 fullBlendAnchor = baseTexureSize * anchorPoint;
    float scale = 1.0;

    //外居中对齐
    float baseAspectRatio = baseTexureSize.y/baseTexureSize.x;
    float blendAspectRatio = maskTexSize.y/maskTexSize.x;
    if(baseAspectRatio >= blendAspectRatio) {
        scale = baseTexureSize.y / maskTexSize.y;
    } else {
        scale = baseTexureSize.x / maskTexSize.x;
    }

    lowp vec4 baseColor = texture2D(inputImageTexture,uv0);
//    lowp vec4 maskColor = maskColorFun(inputMask,baseColor,baseTexureSize,maskTexSize*scaleSize,
//        fullBlendAnchor,scale);
//    vec4 mixColor = mixColorFun(baseColor, maskColor, anchorPoint);
//    lowp vec4 fullblendColor = blendColor(inputMask,baseColor,baseTexureSize,maskTexSize*scaleSize,
//        fullBlendAnchor,scale);
//    gl_FragColor = vec4(maskColor.rgb, 1.0);
//    gl_FragColor = baseColor;

    vec2 anchorPoint = vec2(0.0, 0.0);
    float accurIntensity = 0.0;
    vec2 realMaskTexSize = vec2(0.0);//纹理真实大小即用户将mask缩放后的大小
    float maskFlagVal = 0.0;
    for(int i = 1; i <= int(pointCount); i++){
        if(i == 1){
            anchorPoint = point1;
            accurIntensity = intensity1;
            realMaskTexSize = maskTexSize*scaleSize1;
            maskFlagVal = maskFlag1;
        }
        if(i == 2){
            anchorPoint = point2;
            accurIntensity = intensity2;
            realMaskTexSize = maskTexSize*scaleSize2;
            maskFlagVal = maskFlag2;
        }
        if(i == 3){
            anchorPoint = point3;
            accurIntensity = intensity3;
            realMaskTexSize = maskTexSize*scaleSize3;
            maskFlagVal = maskFlag3;
        }
        if(i == 4){
            anchorPoint = point4;
            accurIntensity = intensity4;
            realMaskTexSize = maskTexSize*scaleSize4;
            maskFlagVal = maskFlag4;
        }
        if(i == 5){
            anchorPoint = point5;
            accurIntensity = intensity5;
            realMaskTexSize = maskTexSize*scaleSize5;
            maskFlagVal = maskFlag5;
        }
        if( i == 6){
            anchorPoint = point6;
            accurIntensity = intensity6;
            realMaskTexSize = maskTexSize*scaleSize6;
            maskFlagVal = maskFlag6;
        }
        if(i == 7){
            anchorPoint = point7;
            accurIntensity = intensity7;
            realMaskTexSize = maskTexSize*scaleSize7;
            maskFlagVal = maskFlag7;
        }
        if(i == 8){
            anchorPoint = point8;
            accurIntensity = intensity8;
            realMaskTexSize = maskTexSize*scaleSize8;
            maskFlagVal = maskFlag8;
        }
        vec2 realAnchorPoint = anchorPoint*baseTexureSize;//锚点即用户点击点的真实坐标
        baseColor = maskColorFun(inputMask,baseColor,baseTexureSize, realMaskTexSize,
        realAnchorPoint,scale, anchorPoint, accurIntensity, maskFlagVal);

        gl_FragColor = baseColor;
    }
    
    if (int(pointCount) == 0) {
        gl_FragColor = texture2D(inputImageTexture,uv0);
    }
}
