local featurePath = "localMask"

EventHandles =
{
    handleComposerUpdateNodeEvent = function (this, path, tag, percentage)
        local feature_base = this:getFeature(featurePath)
        local xt_local_edit = EffectSdk.castGeneralEffectFeature(feature_base)
        if not xt_local_edit then
            print("Error: source filter is nil!")
            return false
        end

        local effect_manager      = this:getEffectManager()
        
        if tag == "localMask" then
            local localPointCount  = effect_manager:getXTLocalEditParam(tag, 0).count
            if localPointCount == 0 then
                 local i = 0
                 local pointName = "point" .. tostring(i+1)
                 xt_local_edit:setUniformVec2("shader", 1, pointName, 0.0, 0.0)
                 
                 local scaleName = "scaleSize" .. tostring(i+1)
                 xt_local_edit:setUniformFloat("shader", 1, scaleName, 0.0)
                 
                 local intensityName = "intensity" .. tostring(i+1)
                 xt_local_edit:setUniformFloat("shader", 1, intensityName, 0.50)
                 
                 local maskFlagName = "maskFlag" .. tostring(i+1)
                 xt_local_edit:setUniformFloat("shader", 1, maskFlagName, 0.0)
                 
                 xt_local_edit:setUniformFloat("shader", 1, "pointCount", 0.0)
            end
            for i = 0, localPointCount - 1 do
                local localEidtInfo = effect_manager:getXTLocalEditParam(tag, i)

                local pointName = "point" .. tostring(i+1)
                local pointXVal = localEidtInfo.pointX
                local pointYVal = localEidtInfo.pointY
                xt_local_edit:setUniformVec2("shader", 1, pointName, pointXVal, pointYVal)
                
                local scaleName = "scaleSize" .. tostring(i+1)
                local scaleVal = localEidtInfo.scaleSize
                xt_local_edit:setUniformFloat("shader", 1, scaleName, scaleVal)
                
                local intensityName = "intensity" .. tostring(i+1)
                local intensityVal = localEidtInfo.intensity
                xt_local_edit:setUniformFloat("shader", 1, intensityName, intensityVal*2.0 - 1.0)
                
                local maskFlagName = "maskFlag" .. tostring(i+1)
                local flagMaskVal = localEidtInfo.maskFlag
                xt_local_edit:setUniformFloat("shader", 1, maskFlagName, flagMaskVal)
                
                xt_local_edit:setUniformFloat("shader", 1, "pointCount", localPointCount)
            end
            return true
        end
    end,
}
