local exports = exports or {}
local Process = Process or {}
Process.__index = Process
function Process.new(construct, ...)
    local self = setmetatable({}, Process)
    if construct and Process.constructor then Process.constructor(self, ...) end
    return self
end

function Process:constructor()

end

function Process:onStart(comp)
    self.material = comp.entity.scene:findEntityBy("Mask"):getComponent("MeshRenderer").material
    self.u_center = Amaz.Vector2f(0.0, 0.0)
    self.u_aspect = Amaz.BuiltinObject.getOutputTextureWidth() / Amaz.BuiltinObject.getOutputTextureHeight()
    self.u_rotate = 0.0
    self.u_size = Amaz.Vector2f(1.0, 1.0)
    self.u_diff = 0.0
    self.u_invert = 0.0
    self.material:setVec2("u_center", self.u_center)
    self.material:setFloat("u_aspect", self.u_aspect)
    self.material:setFloat("u_rotate", self.u_rotate)
    self.material:setVec2("u_size", self.u_size)
    self.material:setFloat("u_diff", self.u_diff)
    self.material:setFloat("u_invert", self.u_invert)
    self.boundaryScaleX = 1.7
    self.boundaryScaleY = 1.7
end

function Process:onUpdate(sys, deltaTime)
    self.u_aspect = Amaz.BuiltinObject.getOutputTextureWidth() / Amaz.BuiltinObject.getOutputTextureHeight()
    self.material:setFloat("u_aspect", self.u_aspect)
end

function Process:onEvent(comp, event)
    -- if event.type == Amaz.AppEventType.SetEffectIntensity then
        if event.args:get(0) == "centerX" then
            self.u_center:Set(event.args:get(2), self.u_center.y)
            self.material:setVec2("u_center", self.u_center)
        elseif event.args:get(0) == "centerY" then
            self.u_center:Set(self.u_center.x, event.args:get(2))
            self.material:setVec2("u_center", self.u_center)
        elseif event.args:get(0) == "width" then
            self.u_size:Set(event.args:get(2) * self.boundaryScaleX, self.u_size.y)
            self.material:setVec2("u_size", self.u_size)
        elseif event.args:get(0) == "height" then
            self.u_size:Set(self.u_size.x, event.args:get(2) * self.boundaryScaleY)
            self.material:setVec2("u_size", self.u_size)
        elseif event.args:get(0) == "rotation" then
            self.u_rotate = (360.0 - event.args:get(2)) * 2.0 * math.pi / 360.0
            self.material:setFloat("u_rotate", self.u_rotate)
        elseif event.args:get(0) == "feather" then
            self.u_diff = event.args:get(2) * 0.5
            self.material:setFloat("u_diff", self.u_diff)
        elseif event.args:get(0) == "invert" then
            if event.args:get(2) > 0.5 then
                self.u_invert = 1.0
            else
                self.u_invert = 0.0
            end
            self.material:setFloat("u_invert", self.u_invert)
        end
    -- end
end

exports.Process = Process
return exports
