precision highp float;

uniform sampler2D inputImageTexture;
uniform sampler2D alphaTexLightSensation;
uniform sampler2D alphaTexTemperature;
uniform sampler2D alphaTexTone;

uniform sampler2D lightSensationLUT;
uniform sampler2D temperatureLUT;
uniform sampler2D toneLUT;

varying vec2 uv;

// 颜色变换结果保存到minTex和maxTex两张LUT图中，可调用此函数得到变换后的颜色值
vec4 locationEffectByTextureMap(sampler2D LUTtexture, vec4 baseColor, float intensity)
{
    float slider_progress = abs(intensity);
    vec4 curColor = baseColor;
    vec4 textureColor = curColor;
    float blueColor = curColor.b * (17.0 - 1.0);
    vec2 standardTableSize = vec2(289.0, 17.0);
    vec2 pixelSize = 1.0 / standardTableSize;
    vec2 quad1 = vec2(0.0);
    quad1.y = floor(floor(blueColor) / 17.0);
    quad1.x = floor(blueColor) - (quad1.y * 1.0);
    vec2 quad2;
    quad2.y = floor(ceil(blueColor) / 17.0);
    quad2.x = ceil(blueColor) - (quad2.y * 1.0);
    vec2 texPos1;
    texPos1.x = (quad1.x * 1.0 / 17.0) + 0.5 / standardTableSize.x + ((1.0 / 17.0 - 1.0 / standardTableSize.x) * textureColor.r);
    texPos1.y = (quad1.y * 1.0 / 1.0) + 0.5 / standardTableSize.y + ((1.0 / 1.0 - 1.0 / standardTableSize.y) * textureColor.g);
    texPos1.y = texPos1.y * 0.5;
    vec2 texPos2;
    texPos2.x = (quad2.x * 1.0 / 17.0) + 0.5 / standardTableSize.x + ((1.0 / 17.0 - 1.0 / standardTableSize.x) * textureColor.r);
    texPos2.y = (quad2.y * 1.0 / 1.0) + 0.5 / standardTableSize.y + ((1.0 / 1.0 - 1.0 / standardTableSize.y) * textureColor.g);
    texPos2.y = texPos2.y * 0.5;

    float alpha = fract(blueColor);
    vec4 newColor = vec4(0.0);
    if (intensity > 0.0) { // 因为对两张LUT图做了合并，上半部分对应于intensity < 0.0的情况，下半部分对应于intensity > 0.0的情况
        texPos1.y = texPos1.y + 0.5;
        texPos2.y = texPos2.y + 0.5;
    }
    vec4 newColor1 = texture2D(LUTtexture, texPos1);
    vec4 newColor2 = texture2D(LUTtexture, texPos2);
    newColor = mix(newColor1, newColor2, alpha);
    newColor = mix(curColor,newColor,slider_progress);
    return newColor;
}

vec4 locationEffectLightSensation(vec4 baseColor, float intensity)
{
    return locationEffectByTextureMap(lightSensationLUT, baseColor, intensity);
}

vec4 locationEffectTemperature(vec4 baseColor, float intensity)
{
    return locationEffectByTextureMap(temperatureLUT, baseColor, intensity);
}

vec4 locationEffectTone(vec4 baseColor, float intensity)
{
    return locationEffectByTextureMap(toneLUT, baseColor, intensity);
}

float getEffectAlphaValue(sampler2D alphaTexture)
{
    vec4 alpha_ = texture2D(alphaTexture, uv);
    float alpha = clamp(alpha_.x - alpha_.y, -1.0, 1.0);
    return alpha;
}

void main() {
    lowp vec4 baseColor = texture2D(inputImageTexture, uv);
    float baseColorA = baseColor.a;
    if(baseColorA > 0.0) baseColor /= baseColorA;
    float alpha = getEffectAlphaValue(alphaTexLightSensation);
    baseColor = locationEffectLightSensation(baseColor, alpha);
    baseColor = clamp(baseColor, 0.0, 1.0);

    alpha = getEffectAlphaValue(alphaTexTemperature);
    baseColor = locationEffectTemperature(baseColor, alpha);
    baseColor = clamp(baseColor, 0.0, 1.0);

    alpha = getEffectAlphaValue(alphaTexTone);
    baseColor = locationEffectTone(baseColor, alpha);
    baseColor = clamp(baseColor, 0.0, 1.0);

    gl_FragColor = baseColor * baseColorA;
}
