precision highp float;
uniform lowp sampler2D sourceTexture;
uniform lowp sampler2D stereoS;
uniform lowp sampler2D stereoH;
uniform float structureStrength;

varying vec2 textureCoordinate;
varying vec2 imageCoord;

uniform int histWidth;

vec4 stereoFun(vec4 baseColor) {
    float testFactor = 0.0;
    float sharpenStrength = 0.0;
    float structureS = 0.0;
    if(structureStrength > 0.00001){
        testFactor = 0.396;
        sharpenStrength = 0.0;
        structureS = 0.76*pow(structureStrength, 2.0);
    }
    if(structureStrength < -0.00001){
        testFactor = 0.456;
        sharpenStrength = 0.0;
        structureS = -0.4*pow(abs(structureStrength), 2.0);
    }
    int modWidth = histWidth/64;
    vec2 realWidthHeight = vec2(float(modWidth), 25.0);

    float destiny = 0.066667;
    vec3 color = baseColor.rgb;
    vec3 textureHsize = vec3(float(histWidth),25.0,0.02);
    float srcLumS = color.r * 0.3333 + color.g * 0.5 + color.b * 0.1667;
    float dstLums = srcLumS - texture2D(stereoS, imageCoord).a;
    color = clamp(color + dstLums * sharpenStrength, 0.0, 1.0);
    
    float lumVal = clamp(srcLumS + clamp(-dstLums,
                                                            -destiny, destiny), 0.0, 1.0)*testFactor*2.0;

    vec2 realPosition = imageCoord * realWidthHeight;
    vec2 minVal = floor(realPosition - 0.5);
    vec2 maxVal = minVal + 1.0;
    minVal = max(minVal, 0.0);
    maxVal = min(maxVal, realWidthHeight - 1.0);
    
    vec2 TX = (vec2(minVal.x, maxVal.x) * 64.0 + 0.1 + lumVal * 63.8) / textureHsize.x;
    vec2 TY = vec2(minVal.y, maxVal.y)  / textureHsize.y + textureHsize.z;
    realPosition -= minVal + 0.5;
    
    vec2 resVal = mix(
                               vec2(texture2D(stereoH, vec2(TX.x, TY.y)).r,
                                    texture2D(stereoH, vec2(TX.x, TY.x)).r),
                               vec2(texture2D(stereoH, vec2(TX.y, TY.y)).r,
                                    texture2D(stereoH, vec2(TX.y, TY.x)).r),
                               realPosition.x);
    
    float mixLum = mix(resVal.y, resVal.x, realPosition.y);
    float finalLum = srcLumS + structureS * (srcLumS * 1.4 - mixLum * 1.484 + 0.042) - 0.5;
    float meanVal = srcLumS - 0.5;
    float scale = min((0.275 - finalLum * finalLum) / (0.275 - meanVal * meanVal) * (1.0 + structureS / 5.0), 5.0);
    
    vec4 result = vec4(0.0, 0.0, 0.0, 1.0);
    result.rgb = finalLum + (color - srcLumS) * scale + 0.5;
    
    return result;
}

void main()
{
    highp vec4 textureColor = texture2D(sourceTexture, textureCoordinate);
    if(textureColor.a > 0.0) textureColor.rgb /= textureColor.a;
    float inColorA = textureColor.a;
    
    gl_FragColor = stereoFun(textureColor)* inColorA;
}
