precision highp float;

uniform sampler2D inputImageTexture;
uniform sampler2D alphaTexBrightness;
uniform sampler2D alphaTexContrast;
uniform sampler2D alphaTexSaturation;

uniform lowp sampler2D stereoS;
uniform lowp sampler2D stereoH;
uniform sampler2D alphaTexStructure;
uniform int histWidth;

varying vec2 uv;


vec4 locationEffectStructure(vec4 baseColor, float intensity) {
    float testFactor = 0.0;
    float sharpenStrength = 0.0;
    float structureS = 0.0;
    if(intensity > 0.00001){
        testFactor = 0.396;
        sharpenStrength = 0.0;
        structureS = 0.76*pow(intensity, 2.0);
    }
    if(intensity < -0.00001){
        testFactor = 0.456;
        sharpenStrength = 0.0;
        structureS = -0.4*pow(abs(intensity), 2.0);
    }
    int modWidth = histWidth/64;
    vec2 realWidthHeight = vec2(float(modWidth), 25.0);

    float destiny = 0.066667;
    vec3 color = baseColor.rgb;
    vec3 textureHsize = vec3(float(histWidth),25.0,0.02);
    float srcLumS = color.r * 0.3333 + color.g * 0.5 + color.b * 0.1667;
    float dstLums = srcLumS - texture2D(stereoS, uv).a;
    color = clamp(color + dstLums * sharpenStrength, 0.0, 1.0);
    
    float lumVal = clamp(srcLumS + clamp(-dstLums, -destiny, destiny), 0.0, 1.0)*testFactor*2.0;

    vec2 realPosition = uv * realWidthHeight;
    vec2 minVal = floor(realPosition - 0.5);
    vec2 maxVal = minVal + 1.0;
    minVal = max(minVal, 0.0);
    maxVal = min(maxVal, realWidthHeight - 1.0);
    
    vec2 TX = (vec2(minVal.x, maxVal.x) * 64.0 + 0.1 + lumVal * 63.8) / textureHsize.x;
    vec2 TY = vec2(minVal.y, maxVal.y)  / textureHsize.y + textureHsize.z;
    realPosition -= minVal + 0.5;
    
    vec2 resVal = mix( vec2(texture2D(stereoH, vec2(TX.x, TY.y)).r,
                            texture2D(stereoH, vec2(TX.x, TY.x)).r),
                        vec2(texture2D(stereoH, vec2(TX.y, TY.y)).r,
                            texture2D(stereoH, vec2(TX.y, TY.x)).r),
                        realPosition.x);
    
    float mixLum = mix(resVal.y, resVal.x, realPosition.y);
    float finalLum = srcLumS + structureS * (srcLumS * 1.4 - mixLum * 1.484 + 0.042) - 0.5;
    float meanVal = srcLumS - 0.5;
    float scale = min((0.275 - finalLum * finalLum) / (0.275 - meanVal * meanVal) * (1.0 + structureS / 5.0), 5.0);
    
    vec4 result = vec4(0.0, 0.0, 0.0, 1.0);
    result.rgb = finalLum + (color - srcLumS) * scale + 0.5;
    result = clamp(result, 0.0, 1.0);
    return result;
}

vec4 locationEffectBrightness(vec4 baseColor, float intensity)
{
    if (intensity < 0.0){
        vec4 res = baseColor + (baseColor + vec4(1.0, 1.0, 1.0, 1.0) * 0.3) * intensity * 0.4;
        return vec4(res.rgb, 1.0);
    } else {
        vec4 res = baseColor + (baseColor + vec4(1.0, 1.0, 1.0, 1.0) * 0.4) * intensity * 0.4;
        return vec4(res.rgb, 1.0);
    }
}

vec4 locationEffectContrast(vec4 baseColor, float intensity)
{
    vec4 mid =vec4(0.5, 0.5, 0.5, 1.0);
    if (intensity < 0.0){
        float intensity_ = 1.0 - intensity * 0.9;
        vec4 res = mid + (baseColor - mid) / intensity_;
        return vec4(res.rgb, 1.0);
    } else {
        float intensity_ = 1.0 + intensity * 0.9;
        vec4 res = mid + (baseColor - mid) * intensity_;
        return vec4(res.rgb, 1.0);
    }
}

vec4 locationEffectSaturation(vec4 baseColor, float intensity)
{
    vec3 luminance_w = vec3(0.2125, 0.7154, 0.0721);
    float luminance = dot(baseColor.rgb,luminance_w);
    vec4 mid =vec4(luminance, luminance, luminance, 1.0);
    if (intensity < 0.0){
        float intensity_ = 1.0 - intensity * 1.2;
        vec4 res = mid + (baseColor - mid) / intensity_;
        return vec4(res.rgb, 1.0);
    } else {
        float intensity_ = 1.0 + intensity * 1.2;
        vec4 res = mid + (baseColor - mid) * intensity_;
        return vec4(res.rgb, 1.0);
    }
}

float getEffectAlphaValue(sampler2D alphaTexture)
{
    vec4 alpha_ = texture2D(alphaTexture, uv);
    float alpha = clamp(alpha_.x - alpha_.y, -1.0, 1.0);
    return alpha;
}

void main() {
    lowp vec4 baseColor = texture2D(inputImageTexture, uv);
    float baseColorA = baseColor.a;
    if(baseColorA > 0.0) baseColor /= baseColorA;
    

    float alpha = getEffectAlphaValue(alphaTexStructure);
    if(abs(alpha)>0.001){
        baseColor = locationEffectStructure(baseColor, alpha);
        baseColor = clamp(baseColor, 0.0, 1.0);
    }
    
    alpha = getEffectAlphaValue(alphaTexBrightness);
    if(abs(alpha)>0.001){
        baseColor = locationEffectBrightness(baseColor, alpha);
        baseColor = clamp(baseColor, 0.0, 1.0);
    }

    alpha = getEffectAlphaValue(alphaTexContrast);
    if(abs(alpha)>0.001){
        baseColor = locationEffectContrast(baseColor, alpha);
        baseColor = clamp(baseColor, 0.0, 1.0);
    }

    alpha = getEffectAlphaValue(alphaTexSaturation);
    if(abs(alpha)>0.001){
        baseColor = locationEffectSaturation(baseColor, alpha);
        baseColor = clamp(baseColor, 0.0, 1.0);
    }

    gl_FragColor = baseColor * baseColorA;
}
