precision highp float;
uniform sampler2D inputImageTexture;

uniform sampler2D inputMask;
varying vec2 uv;

#define uv0 uv

uniform int baseTexWidth;
uniform int baseTexHeight;
uniform vec2 maskTexSize;

uniform float intensity1;
uniform float intensity2;
uniform float intensity3;
uniform float intensity4;
uniform float intensity5;
uniform float intensity6;
uniform float intensity7;
uniform float intensity8;

uniform float scaleSize1;//scaleSize对素材图也就是mask图按比例缩放
uniform float scaleSize2;
uniform float scaleSize3;
uniform float scaleSize4;
uniform float scaleSize5;
uniform float scaleSize6;
uniform float scaleSize7;
uniform float scaleSize8;

uniform float pointCount;
uniform vec2 point1;
uniform vec2 point2;
uniform vec2 point3;
uniform vec2 point4;
uniform vec2 point5;
uniform vec2 point6;
uniform vec2 point7;
uniform vec2 point8;


vec2 sucaiAlign(vec2 videoUV,vec2 videoSize,vec2 sucaiSize,vec2 anchorImageCoord,float sucaiScale)
{
    vec2 videoImageCoord = videoUV * videoSize;
    vec2 sucaiUV= (videoImageCoord - anchorImageCoord)/(sucaiSize*sucaiScale*2.2) + vec2(0.5);//scaleSize对素材图也就是mask图按比例缩放
    return sucaiUV;
}
vec3 rgb2ycbcr(vec3 c){
	float y=.299*c.r+.587*c.g+.114*c.b;
	return vec3(y, (c.b-y)*.565, (c.r-y)*.713);
}
vec3 rgb2hsv(vec3 c){
        vec4 K=vec4(0.,-1./3.,2./3.,-1.),
             p=mix(vec4(c.bg ,K.wz),vec4(c.gb,K.xy ),step(c.b,c.g)),
             q=mix(vec4(p.xyw,c.r ),vec4(c.r ,p.yzx),step(p.x,c.r));
        float d=q.x-min(q.w,q.y),
              e=1e-10;
        return vec3(abs(q.z+(q.w-q.y)/(6.*d+e)),d/(q.x+e),q.x);
}
float hsvDistanceOf(vec3 hsv1, vec3 hsv2) {
    float x1 = hsv1.z * hsv1.y * cos(hsv1.x * 2.0 * 3.1415926);
    float y1 = hsv1.z * hsv1.y * sin(hsv1.x * 2.0 * 3.1415926);
    float z1 = 1.4*(1.0 - hsv1.z);
    float x2 = hsv2.z * hsv2.y * cos(hsv2.x * 2.0 * 3.1415926);
    float y2 = hsv2.z * hsv2.y * sin(hsv2.x * 2.0 * 3.1415926);
    float z2 = 1.4*(1.0 - hsv2.z);
    return distance(vec3(x1, y1, z1), vec3(x2, y2, z2));;
}
// maskFlag参数只有在localMask里面才用到，这里已经删去
float alphaCalc(sampler2D sucai, vec4 baseColor,vec2 videoSize,vec2 sucaiSize,vec2 anchorImageCoord,float sucaiScale, vec2 anchorPoint, float accurIntensity)
{
    vec2 sucaiUV = sucaiAlign(uv0,videoSize,sucaiSize,anchorImageCoord,sucaiScale);
    lowp vec4 maskColor = texture2D(sucai,sucaiUV);
    vec3 srcAnchor = texture2D(inputImageTexture, anchorPoint).rgb;
    
    // vec3 baseColor_hsv = rgb2ycbcr(baseColor.rgb);
    // vec3 srcAnchor_hsv = rgb2ycbcr(srcAnchor);
    // float diff = distance(baseColor_hsv, srcAnchor_hsv);
    // float realDist = clamp(diff*(3.0), 0.0, 1.0);

    // vec3 baseColor_hsv = rgb2hsv(baseColor.rgb);
    // vec3 srcAnchor_hsv = rgb2hsv(srcAnchor);
    // float diff = hsvDistanceOf(baseColor_hsv, srcAnchor_hsv);
    // float realDist = clamp(diff*(1.6), 0.0, 1.0);
        
    float diff = distance(baseColor.rgb, srcAnchor);
    float realDist = clamp(diff, 0.0, 1.0);

    realDist = (1.0 - realDist) * accurIntensity * maskColor.a * 0.9;
    return realDist;
}

void main(void)
{
    vec2 baseTexureSize = vec2(baseTexWidth,baseTexHeight);
//    vec2 fullBlendAnchor = baseTexureSize * anchorPoint;
    float scale = 1.0;

    //外居中对齐
    float baseAspectRatio = baseTexureSize.y/baseTexureSize.x;
    float blendAspectRatio = maskTexSize.y/maskTexSize.x;
    if(baseAspectRatio >= blendAspectRatio) {
        scale = baseTexureSize.y / maskTexSize.y;
    } else {
        scale = baseTexureSize.x / maskTexSize.x;
    }

    lowp vec4 baseColor = texture2D(inputImageTexture,uv0);

    vec2 anchorPoint = vec2(0.0, 0.0);
    float accurIntensity = 0.0;
    vec2 realMaskTexSize = vec2(0.0);//纹理真实大小即用户将mask缩放后的大小

    vec4 anchorRGB = vec4(0.0);
    float alpha_Neg = 0.0;
    float alpha_Pos = 0.0;
    for(int i = 1; i <= int(pointCount); i++){
        if(i == 1){
            anchorPoint = point1;
            accurIntensity = intensity1;
            realMaskTexSize = maskTexSize*scaleSize1;
        }
        if(i == 2){
            anchorPoint = point2;
            accurIntensity = intensity2;
            realMaskTexSize = maskTexSize*scaleSize2;
        }
        if(i == 3){
            anchorPoint = point3;
            accurIntensity = intensity3;
            realMaskTexSize = maskTexSize*scaleSize3;
        }
        if(i == 4){
            anchorPoint = point4;
            accurIntensity = intensity4;
            realMaskTexSize = maskTexSize*scaleSize4;
        }
        if(i == 5){
            anchorPoint = point5;
            accurIntensity = intensity5;
            realMaskTexSize = maskTexSize*scaleSize5;
        }
        if( i == 6){
            anchorPoint = point6;
            accurIntensity = intensity6;
            realMaskTexSize = maskTexSize*scaleSize6;
        }
        if(i == 7){
            anchorPoint = point7;
            accurIntensity = intensity7;
            realMaskTexSize = maskTexSize*scaleSize7;
        }
        if(i == 8){
            anchorPoint = point8;
            accurIntensity = intensity8;
            realMaskTexSize = maskTexSize*scaleSize8;
        }
        vec2 realAnchorPoint = anchorPoint*baseTexureSize;//锚点即用户点击点的真实坐标

        float alpha = alphaCalc(inputMask,baseColor,baseTexureSize, realMaskTexSize, realAnchorPoint,scale, anchorPoint, accurIntensity);
        if(alpha >= 0.0)
        {
            alpha_Pos = 1.0 - (1.0 - alpha_Pos) * (1.0 - alpha);
        }
        else
        {
            alpha_Neg = (1.0 + alpha_Neg) * (1.0 + alpha) - 1.0;
        }
    }

    float alpha = alpha_Pos + alpha_Neg;
    gl_FragColor = vec4(clamp(alpha, 0.0, 1.0), clamp(-alpha, 0.0, 1.0), 0.0, 1.0);
}
