

local Object = require "venuscore.rtti.object"
local venuscore = require "libvenuscore"

local MEncoder = Object:extend("FEncoder")

function MEncoder:new(serializer)
  self.serializer = serializer;
  self.memberList = {};
end

function MEncoder:GetChild()
  return self.serializer:GetEncoder();
end

function MEncoder:GetMemberList()
  return self.memberList;
end

function MEncoder:_SetMember(key,value)
  self.memberList[key] = value;
end

function MEncoder:SetTypename(typename)
  self:SetFieldString("__typename",typename);
end

--Reference类型需要特殊组织
function MEncoder:SetFieldReference(name,value,count,index,parentName)
  if value == "" then
    --空字符串不序列化与反序列化
    return;
  end
    local fieldValue = {};
    fieldValue["__typename"] = venuscore.ScriptTypes.ReferenceTypeName;
    fieldValue["refid"] = value;
    fieldValue["fieldName"] = name;
    fieldValue["fieldCount"] = count;
    fieldValue["parentName"] = parentName;
    fieldValue["number"] = index;
  
  self:_SetMember(name,fieldValue);
end


function MEncoder:SetFieldString(name,value)
  if value == "" then
    --空字符串不序列化与反序列化
    return;
  end
  self:_SetMember(name,value);
end


function MEncoder:SetFieldInt(name,value)
  self:_SetMember(name,value);
end


function MEncoder:SetFieldFloat(name,value)
  self:_SetMember(name,value);
end

function MEncoder:SetFieldDouble(name,value)
  self:_SetMember(name,value);
end

--序列化不了bool类型？
function MEncoder:SetFieldBool(name,value)
  self:_SetMember(name,value);
end


function MEncoder:SetFieldClass(name, encoder)
  local memberList = encoder:GetMemberList();
  self:_SetMember(name,memberList);
  
end


return  MEncoder;