local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"

local fourimg = {}
fourimg.renderobj = nil;
fourimg.material = nil;
fourimg.Queue = 200;

function fourimg:Initialize(host, size)
  self.RATIOASPECT = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,"RATIOASPECT");
  self.renderobj = host:CreateRenderObject();
  self.material = host:CreateMaterial("comm:documents/Filter/material/fourimg.material");
  self.material:SetParameter(self.RATIOASPECT, mathfunction.vector1(size:y()/size:x()) );
  return self.Queue;
end

function fourimg:Resizeview(size)
end

function fourimg:Process(context, Original, Scene, Output)
  context:BeginRenderPass(Output, apolloengine.RenderTargetEntity.CF_COLOR);
  self.material:SetParameter(
    apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
    Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  context:Draw(self.renderobj, self.material);
  context:EndRenderPass();
end

return fourimg;

