local BD = require "bluecore.bluedefined"
local BU = require "bluecore.blueutility"
local BR = require "bluecore.core.blue_rtti"
local Types = require "venuscore.rtti.types"
local BlueNode = require "bluecore.bluenode"
local BlueprintSelf = require "bluecore.core.blueprint_self"
local BluePinInfo = require "bluecore.bluepininfo"
local UnBindEventDispatcher4All = BlueNode:extend();

UnBindEventDispatcher4All:MemberRegister("_clsId");
UnBindEventDispatcher4All:MemberRegister("_dispId");
UnBindEventDispatcher4All:MemberRegister("nodeName");

function UnBindEventDispatcher4All:new(graph)

  UnBindEventDispatcher4All.super.new(self, graph)

  self._inputInfoArray = {}  -- 简化版本的 arg_info

end


function UnBindEventDispatcher4All:_OnBeginCreateEd(clsUid, dispatchId)
  self._clsId = clsUid;
  self._dispId = dispatchId ;
  self:_Setup(self._clsId,  self._dispId)
end

function UnBindEventDispatcher4All:DynamicRegisterInput(argId, rtti, name, tips, default, delAble, groupName)

  if tips == nil then tips = "["..tostring(argId).."]" end
  if name == nil then name = "["..tostring(argId).."]" end

  local info = BluePinInfo(BD.PIN_DATA_INPUT, argId, rtti, name, tips, default, delAble, groupName);
  self.infoTable[BD.PIN_DATA_INPUT][argId] = info

  return info ;

end

-- 蓝图类相关的 比如 函数调用/事件分发器调用/绑定/取消绑定/取消所有绑定 都是在 _OnDeserializePost 阶段才完成引脚的重建
-- 特化的蓝图节点 是不依赖其他节点的
function UnBindEventDispatcher4All:_OnDeserializePost()
  self:_Setup(self._clsId,  self._dispId)
end

function UnBindEventDispatcher4All:_Setup(clsUid, dispatchId)

  local originExecInputsInfo = self.infoTable[BD.PIN_EXEC_INPUT]
  local originExecOutputsInfo = self.infoTable[BD.PIN_EXEC_OUTPUT]

  self.infoTable = {}
  self.infoTable[BD.PIN_DATA_INPUT] = {}  -- 1: Types.BlueprintType 2: Types.EventDelegateType
  self.infoTable[BD.PIN_DATA_OUTPUT] = {} -- no
  self.infoTable[BD.PIN_EXEC_INPUT]  = originExecInputsInfo
  self.infoTable[BD.PIN_EXEC_OUTPUT] = originExecOutputsInfo

  local blueType

  if _KRATOSEDITOR then

    local clsInfo = BR.GetClassesByIdEd(clsUid);
    local dispatcher
    if clsInfo ~= nil then
      blueType = BR.GetRttiByClsId(clsUid);
      local dispatchers = clsInfo:GetEventDispatchers()
      dispatcher = dispatchers[dispatchId]
      if dispatcher ~= nil then
        self:SetFunctionName("Unbind All Events From "..dispatcher:GetName())
      else
        self._failReason = "Dispatcher is deleted"
      end
    else
      self._failReason = "Class is deleted"
    end

    if blueType == nil then
      blueType = Types.BlueprintType.INVALID_BLUEPRINT_TYPE
    end

    if dispatcher == nil then
      self:SetFunctionName("Unbind All Events From n/a")
    else
      dispatcher:AddRefactor(self);
    end

  else
    self:SetFunctionName("Unbind All Events From default")
    blueType = Types.BlueprintType.INVALID_BLUEPRINT_TYPE
  end

  local label = "Target"
  self:DynamicRegisterInput(1, blueType, label, label, BlueprintSelf());

end

function UnBindEventDispatcher4All:IsAllowDuplicate()
  return false;
end

function UnBindEventDispatcher4All:EditorPinAdd( )

end

function UnBindEventDispatcher4All:EditorPinDelete( )

end

function UnBindEventDispatcher4All:InfoChange( )

end

function UnBindEventDispatcher4All:NameChanged(oldName, newName)
  self:SetFunctionName("Unbind All Events From "..newName)  -- 不影响序列化信息
end

function UnBindEventDispatcher4All:ToBeDeletedEd()

  local classInfo = BR.GetClassesByIdEd(self._clsId);
  local dispatchers = classInfo:GetEventDispatchers()
  local dispatcherInfo = dispatchers[self._dispId]
  local name = dispatcherInfo:GetName()
  self._failReason = "dispatcher  "..tostring(name).." is deleted"

end

-- Node delete by editor
function UnBindEventDispatcher4All:_OnDeleteEd()
  local classInfo = BR.GetClassesByIdEd(self._clsId);
  if classInfo ~= nil then
    local dispatchers = classInfo:GetEventDispatchers()
    local dispatcherInfo = dispatchers[self._dispId]
    if dispatcherInfo ~= nil then
      dispatcherInfo:RemoveRefactor(self)
    else
      WARNING(string.format("Dispatcher deleted before %s %s", tostring(self._clsId), tostring(self._dispId)))
    end
  else
    WARNING(string.format("Class deleted before %s %s", tostring(self._clsId), tostring(self._dispId)))
  end
end

function UnBindEventDispatcher4All:_OnCompile()
  if self._failReason then
    self.compileResult = self._failReason
    return false ;
  end
  return true
end

function UnBindEventDispatcher4All:_OnUpdateByEditor()
  if self._failReason then
    self.compileResult = self._failReason
  end
end

function UnBindEventDispatcher4All:_OnUpdate(args)
  local variation = args[1]
  if variation.GetTypeName then
    local blueprint = variation
    local dispatcher = blueprint:GetEventDispatcherByUid(self._dispId)
    dispatcher:RemoveAllDelegate();
  else
    for _, blueprint in pairs(variation) do
      local dispatcher = blueprint:GetEventDispatcherByUid(self._dispId)
      dispatcher:RemoveAllDelegate();
    end
  end
end

-- override
function UnBindEventDispatcher4All:IsInputArrayCompatible(pinInfo)
  if pinInfo.argId == 1 and pinInfo.pinType == BD.PIN_DATA_INPUT then
    return true -- 第一个数据引脚是BlueprintType
  end
  return false
end

function UnBindEventDispatcher4All:ClsIdChgEd(oldClassId, newClassId)

  if oldClassId ==  self._clsId then

    local classInfo = BR.GetClassesByIdEd(self._clsId);
    local dispatchers = classInfo:GetEventDispatchers()
    local dispatcherInfo = dispatchers[self._dispId]
    dispatcherInfo:RemoveRefactor(self)

    self._clsId =  newClassId
    local blueType = BR.GetRttiByClsId(self._clsId);
    local bluePinInfo = self.infoTable[BD.PIN_DATA_INPUT][1]
    bluePinInfo:ChangeRtti(blueType, BlueprintSelf())
  end
end

UnBindEventDispatcher4All:RegisterExecInput(1, "exec", "Execute");
UnBindEventDispatcher4All:RegisterExecOutput(1, "exec", "Execute");
UnBindEventDispatcher4All:SetFunctionName("UnBind Event Dispatcher");
UnBindEventDispatcher4All:SetFunctionType(BD.EVENT_DISPATCH_NODE);


return UnBindEventDispatcher4All
