local AE = require "apolloengine"
local BN = require "bluecore.bluenode"
local BD = require "bluecore.bluedefined"
local Types = require "venuscore.rtti.types"
local Ratio = BN:extend();

function Ratio:new(...)
  Ratio.super.new(self, ...)
end

function Ratio:_OnUpdate(args)
  local resolution
  if _KRATOSEDITOR then
    local scene = AE.SceneManager:GetOrCreateScene("facecuteScene"); --previewscene
    local fbo = scene:GetDefaultRenderTarget();
    local tex = fbo:GetAttachment(AE.RenderTargetEntity.TA_COLOR_0);
    resolution = tex:GetSize();
  else
    resolution = AE.Framework:GetResolution();
  end
  return  args[1] and resolution:x()/resolution:y() or resolution:y()/resolution:x()
end

Ratio:RegisterInput(1, Types.BoolType, "w/h?", "w/h or h/w", true);
Ratio:RegisterOutput(1, Types.FloatType, "Ratio", "w/h or h/w");
Ratio:SetFunctionName("Ratio");
Ratio:SetFunctionType(BD.STATIC_FUNCTION_NODE);

return Ratio;

