local BlueNode = require "bluecore.bluenode"
local BD = require "bluecore.bluedefined"
local Types = require "venuscore.rtti.types"

local Sin = BlueNode:extend();

---- 游戏运行模式
function Sin:new(...)
  Sin.super.new(self, ...)
end

function Sin:_OnUpdate(args)
  
  return math.sin(args[1]), math.sin(args[2]*math.pi/180.0);
end

---- 编辑器模式

Sin:RegisterInput(1, Types.FloatType, "pi", "[1]", 0);
Sin:RegisterInput(2, Types.FloatType, "angle", "[2]", 0);
Sin:RegisterOutput(1, Types.FloatType, "sin(pi)", "正弦结果(输入弧度)");
Sin:RegisterOutput(2, Types.FloatType, "sin(angle)", "正弦结果(输入角度)");
Sin:SetFunctionName("Sin");
Sin:SetFunctionType(BD.STATIC_FUNCTION_NODE);

return Sin;

