local BlueNode = require "bluecore.bluenode"
local Types = require "venuscore.rtti.types"
local BlueSelf = require "bluecore.blueself"
local EventDispatcher = require "bluecore.eventdispatcher"
local AE = require "apolloengine"
local BlueDefined = require "bluecore.bluedefined"

local OnCollisionEnter = BlueNode:extend();

function OnCollisionEnter:new(...)
  OnCollisionEnter.super.new(self, ...)
end

function OnCollisionEnter:_OnUpdate(eventParam)
  return eventParam;
end

function OnCollisionEnter:RegisterTriggerFunc(func, bluePrintSelf)
  self:_GetInput()
  EventDispatcher:RegisterCallback(self.inputArgs[1]:GetContentPath(), BlueDefined.Event.CollisionEvent.Enter, func, bluePrintSelf);
end

OnCollisionEnter:RegisterInput(1, AE.RigidBodyComponent:RTTI(), "component", "监听组件", BlueSelf());
OnCollisionEnter:RegisterOutput(1, AE.Node:RTTI(), "target", "返回碰撞的对象");

OnCollisionEnter:RegisterExecOutput(1, "OnTrigger", "执行");

OnCollisionEnter:SetFunctionName("_OnCollisionEnter");

OnCollisionEnter:SetFunctionType(BlueDefined.EVENT_FUNCTION_NODE);

OnCollisionEnter:SetEventType(BlueDefined.EventType.RegisterCallback);

return OnCollisionEnter;

