local BlueNode = require "bluecore.bluenode"
local EventDispatcher = require "bluecore.eventdispatcher"
local BlueDefined = require "bluecore.bluedefined"
local apolloengine = require "apolloengine"
local BlueSelf = require "bluecore.blueself"
local Types = require "venuscore.rtti.types"
local OnFrameAniPlay = BlueNode:extend();

---- 游戏运行模式
function OnFrameAniPlay:new(...)
  OnFrameAniPlay.super.new(self, ...)
  self.edge = true;
end

function OnFrameAniPlay:_OnUpdate(eventParam)
  self.output = eventParam
end

function OnFrameAniPlay:_OnNextBranch() --Update函数调用
  if self.edge and not self.output.isEdge then --设定了边缘触发但是不是边缘触发
    return 0
  else
    return 1
  end
end

function OnFrameAniPlay:RegisterTriggerFunc(func, bluePrintSelf)
  self:_GetInput()
  self.edge = self.inputArgs[2];
  EventDispatcher:RegisterCallback(self.inputArgs[1]:GetContentPath(), BlueDefined.Event.FrameAnimationEvent.Play, func, bluePrintSelf);
end

---- 编辑器模式
OnFrameAniPlay:RegisterInput(1, apolloengine.FrameAnimationComponent:RTTI(), "component", "监听组件", BlueSelf());
OnFrameAniPlay:RegisterInput(2, Types.BoolType, "edge", "边缘触发", true);

OnFrameAniPlay:RegisterExecOutput(1, "OnTrigger", "执行");

OnFrameAniPlay:SetFunctionName("_OnFrameAnimationPlay");

OnFrameAniPlay:SetFunctionType(BlueDefined.EVENT_FUNCTION_NODE);

OnFrameAniPlay:SetEventType(BlueDefined.EventType.RegisterCallback);

return OnFrameAniPlay;

