local Types = require "venuscore.rtti.types"
local BlueDynamicAnyTypePinsNode = require "bluecore.base.blue_dynamic_anytype_pins_node"
local BD = require "bluecore.bluedefined"

local Sequence = BlueDynamicAnyTypePinsNode:extend();

---- 游戏运行模式
function Sequence:new(...)
  Sequence.super.new(self, ...)
end



function Sequence:Update(_execIdx)
  for i = 1, #self.execOutputs do
    local lastNode = self;
    local execIdx  = i;
    local nextIdx  = self.nextExecIndex[i];
    local nextNode = self.nextExecNodes[i];
    if _KRATOSEDITOR then
      local BuEd = require "bluecore.editor.blueutility_ed"
      BuEd:BlueDebugYield(self);
    end
    while nextNode ~= nil
    do
      if _KRATOSEDITOR then
        local link_uid = lastNode.execOutputs[execIdx].links[1].linkUid;
        self.graph:AddExecLinkList(link_uid);
      end
      lastNode = nextNode;
      execIdx  = nextNode:Update(nextIdx);
      nextIdx  = nextNode.nextExecIndex[execIdx];
      nextNode = nextNode.nextExecNodes[execIdx];

    end
  end
end


---- 编辑器模式

-- 在编辑器交互上创建时候回调 (避免数据和反序列化重叠 e.g table.insert操作)
function Sequence:_OnCreateWithEditor()
  Sequence.super._OnCreateWithEditor(self);
end

-- 当删除pin的时候,由于pin脚顺序发生改变,回调给具体节点类进行修改
function Sequence:_OnOrderChange(pinInfo, oldIdx, newIdx)
  pinInfo.name = "then ["..(newIdx).."]"
  pinInfo.tips = "then ["..(newIdx).."]"
  ERROR("pinInfo Update "..tostring(pinInfo.name)..","..tostring(pinInfo.tips))
end

Sequence._OnAdd = function(thisNode)
  local inputInfo = thisNode.infoTable[BD.PIN_EXEC_OUTPUT][1]
  local pinUid = thisNode.graph:_NextID();
  local nodeUid = thisNode.uid;
  local newArgId = 1
  for _ , __ in pairs(thisNode[BD.EXEC_OUTPUTS_INFO]) do
    newArgId = newArgId + 1
  end
  local inputPin = thisNode:AppendExecOutput(Types.ExecPinType, "then ["..(newArgId).."]", "执行 ["..(newArgId).."]", nil, pinUid, nodeUid, true);

  return inputPin
end

-- 之前已经删除连接信息,索引表在执行完所有删除操作之后才会移除对应pin/node
Sequence._OnDel = function(thisNode, execOutputPin)
  thisNode:RemoveExecOutput(execOutputPin);
  return true
end
Sequence:RegisterExecInput(1, "exec", "Execute");
Sequence:RegisterExecOutput(1, "then [1]", "执行 1");
Sequence:RegisterExecOutput(2, "then [2]", "执行 2");

Sequence:RegisterMoreExecOutput("exec", BD.OP_ADD, "增加输出执行节点引脚", Sequence._OnAdd, BD.OP_DEL, "删除输出执行节点引脚", Sequence._OnDel);
Sequence:SetFunctionName("Sequence");

return Sequence ;

