local mf = require "mathfunction"
local BlueNode = require "bluecore.bluenode"

local Types = require "venuscore.rtti.types"

local BreakCollision = BlueNode:extend();

---- 游戏运行模式
function BreakCollision:new(...)
  BreakCollision.super.new(self, ...)
end

function BreakCollision:_OnUpdate(args)
  local CollisionPointInfo = args[1];
  return CollisionPointInfo:GetCollisionPosition(),
  CollisionPointInfo:GetCollisionWorldPosition(),
  CollisionPointInfo:GetCollisionDirection()
end


---- 编辑器模式
BreakCollision:RegisterInput(1, Types.CollisionDataType, "Collision", "碰撞信息", Types.NotNullType());
BreakCollision:RegisterOutput(1, mf.vector3:RTTI(), "position in model", "模型坐标");
BreakCollision:RegisterOutput(2, mf.vector3:RTTI(), "position in world", "世界坐标");
BreakCollision:RegisterOutput(3, mf.vector3:RTTI(), "direction in world", "碰撞方向(世界)");
BreakCollision:SetFunctionName("Break Collision");

return BreakCollision;

