local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local BlueNode = require "bluecore.bluenode"
local BlueSelf = require "bluecore.blueself"
local Types = require "venuscore.rtti.types"

local Volume = BlueNode:extend();

function Volume:new(...)
  Volume.super.new(self, ...);
end

function Volume:_OnUpdate(args)
  if args[2] > -20 and args[2] < 20 then
      args[1].volume = args[2];
  end
end

Volume:RegisterInput(1, apolloengine.AudioComponent:RTTI(), "target", "音量调节/db", BlueSelf());

Volume:RegisterInput(2, Types.IntType, "Volume Gain", "音量增益范围[-20,20]", 0);

Volume:RegisterExecInput(1, "exec", "Execute");

Volume:RegisterExecOutput(1, "exec", "Execute");

Volume:SetFunctionName("AudioVolumeSet");

return Volume;
