local libvenuscore = require "libvenuscore"
local Types = require "venuscore.rtti.types"

local BlueDumper = require "bluecore.bluedumper"
local BlueDefined = require "bluecore.bluedefined"
local BlueDemo = libvenuscore.Object:extend();

function BlueDemo:new(wrap, com, graph)
  self.wrap = wrap   -- bluewrap of blueprint command wrapper
  self.com = com     -- blueprint component
  self.graph = graph -- editor scene blueprint
  self.isTestDone = false
  self.isTestStep = false
  self.stepIndex = 1
end

function BlueDemo:IsTestDone()
  return self.isTestDone
end

function BlueDemo:SetTestDone()
  self.isTestDone = true
end

function BlueDemo:IsTestStep()
  return self.isTestStep;
end

function BlueDemo:SetTestStep()
  self.isTestStep = true
end

function BlueDemo:TDD()
  while self:_TDD(self.stepIndex) do
    self.stepIndex = self.stepIndex + 1
  end
  self:SetTestDone();
  WARNING("demo tdd end with total step "..tostring(self.stepIndex))
end

function BlueDemo:Step()
  self:SetTestStep(true);
  local isContinue = self:_TDD(self.stepIndex)
  self.stepIndex = self.stepIndex + 1
  if not isContinue then
    self:SetTestStep(false);
    self:SetTestDone();
    WARNING("demo step end with total step "..tostring(self.stepIndex))
  end
end

function BlueDemo:_TDD(index)

  local continue = true

  if index == 1 then
    WARNING("");
    WARNING("");
    WARNING("Begin Demo")
    ------------------------------------------------------------------
    -- 创建最简demo
    WARNING("Add BlueNode And Link ")

    self.tick = self.wrap:AddBluePrintNode("bluecore.bluenodes.event.tick", -815, -448)

    self.getTransformComponent =  self.wrap:AddBluePrintNode("bluecore.bluenodes.apolloengine.node.gettransformcomponent", -600, -84)

    self.setLocalPosition = self.wrap:AddBluePrintNode("bluecore.bluenodes.apolloengine.componet.transform.transformcomponent.setlocalposition", -306, 28)

    self.rx = self.wrap:AddBluePrintNode("bluecore.bluenodes.mathfunction.random.randomscalar", -884, -20);
    self.ry = self.wrap:AddBluePrintNode("bluecore.bluenodes.mathfunction.random.randomscalar", -884, 76);
    self.rz = self.wrap:AddBluePrintNode("bluecore.bluenodes.mathfunction.random.randomscalar", 14, 100);

    self.make = self.wrap:AddBluePrintNode("bluecore.bluenodes.mathfunction.vector3f.makevector3f", -672, 20);

    self.print_result =  self.wrap:AddBluePrintNode("bluecore.bluenodes.utility.print", -38, 28)

    -- 执行流
    self.execlink = self.wrap:LinkPinToPin(self.tick.execOutputs[1].uid, self.setLocalPosition.execInputs[1].uid)

    -- 数据流
    self.wrap:LinkPinToPin(self.getTransformComponent.outputs[1].uid, self.setLocalPosition.inputs[1].uid)
    self.wrap:LinkPinToPin(self.rx.outputs[1].uid, self.make.inputs[1].uid)
    self.wrap:LinkPinToPin(self.ry.outputs[1].uid, self.make.inputs[2].uid)
    self.wrap:LinkPinToPin(self.rz.outputs[1].uid, self.make.inputs[3].uid)
    self.wrap:LinkPinToPin(self.make.outputs[1].uid, self.setLocalPosition.inputs[2].uid)

    -- 打印 SetLocalPosition的结果 (下一个节点依赖上一个执行节点的一个输出)
    self.wrap:LinkPinToPin(self.setLocalPosition.execOutputs[1].uid, self.print_result.execInputs[1].uid)
    self.wrap:LinkPinToPin(self.setLocalPosition.outputs[1].uid, self.print_result.inputs[1].uid)

    LOG("Edit:")
    BlueDumper.dump(self.graph);
    LOG("Game:")
    BlueDumper.dump(self:_GetGameInstance())
    LOG("End Stage 1")

    goto CONTINUE
  end
  -------------------------------------------------------------------
  ----- 删除节点
  if index == 2 then
    WARNING("Delete BlueNode ")
    self.wrap:DeleteBlueNode(self.make.uid);
    --BlueDumper.dump(self.graph);
    goto CONTINUE
  end
  -------------------------------------------------------------------
  ----- 创建节点
  if index == 3 then
    WARNING("Create BlueNode ")
    self.make2 = self.wrap:AddBluePrintNode("bluecore.bluenodes.mathfunction.vector3f.makevector3f", -672, 20)
    self.wrap:LinkPinToPin(self.rx.outputs[1].uid, self.make2.inputs[1].uid)
    self.wrap:LinkPinToPin(self.ry.outputs[1].uid, self.make2.inputs[2].uid)
    self.wrap:LinkPinToPin(self.rz.outputs[1].uid, self.make2.inputs[3].uid)
    self.lnk = self.wrap:LinkPinToPin(self.make2.outputs[1].uid, self.setLocalPosition.inputs[2].uid)
    --BlueDumper.dump(self.graph);
    goto CONTINUE
  end
  -------------------------------------------------------------------
  ----- 删除连线
  if index == 4 then
    WARNING("Delete BlueLink ")
    self.wrap:DeleteBlueLink(self.lnk[BlueDefined.LINK_UID]);
    --BlueDumper.dump(self.graph);
    goto CONTINUE
  end
  -------------------------------------------------------------------
  ----- 创建连线
  if index == 5 then
    WARNING("Create BlueLink ")
    self.wrap:LinkPinToPin(self.make2.outputs[1].uid, self.setLocalPosition.inputs[2].uid)
    --BlueDumper.dump(self.graph);
    goto CONTINUE
  end
  -------------------------------------------------------------------
  ----- 引脚使用字面值/常量
  if index == 6 then
    WARNING("\n\n\nDelete Node, And Use Constant/Default Value\n")
    self.wrap:DeleteBlueNode(self.rz.uid);
    self.wrap:SetInputPinLiteral(self.make2.inputs[3].uid, 0.5);
    --BlueDumper.dump(self.graph);
    goto CONTINUE
  end
  -------------------------------------------------------------------
  -- 创建第一个变量
  if index == 7 then
    WARNING("Create Variable and Add Get Node")

    self.var = self.wrap:CreateVariable();

    -- 创建变量的Get节点
    self.spec_data_tbl = self.var:GetSpecData()
    self.cls = self.graph:GetNodeClass("bluecore.variable.getvariable" ,self.spec_data_tbl);
    self.pause_get_node = self.wrap:AddBluePrintNode(self.cls, -832, -308); -- FIXME(hhl) bug here

    -- 模拟 反射面板修改 变量类型
    local SetScriptValueByKeys = require "window.editor.command.commands.scriptcomponent.set_script_value_by_keys_command"
    local keys = {}
    table.insert(keys, "bluePrintVariableList")
    table.insert(keys, 1)
    table.insert(keys, "base_rtti_name")
    local CmdMgr = require "window.editor.command.command_manager"
    local cmd = SetScriptValueByKeys(self.com:GetContentPath(), "comm:script/bluecore/blueprint.lua", keys, Types.BoolType:GetTypeName());
    CmdMgr:DoIt(cmd);

    local keys2 = {}
    table.insert(keys2, "bluePrintVariableList")
    table.insert(keys2, 1)
    table.insert(keys2, "name")
    local cmd2 = SetScriptValueByKeys(self.com:GetContentPath(), "comm:script/bluecore/blueprint.lua", keys2, "mTDDVarBool");
    CmdMgr:DoIt(cmd2);

    --LOG("Edit:")
    --BlueDumper.dump(self.graph);
    --LOG("Game:")
    --BlueDumper.dump(self:_GetGameInstance())
    goto CONTINUE
  end
  -------------------------------------------------------------------
  -- Get连接if else节点
  if index == 8 then
    WARNING("Create If-else Logic Node")

    self.ifelse = self.wrap:AddBluePrintNode("bluecore.bluenodes.controlflow.ifelse", -408, -352); -- ifelse逻辑节点

    self.wrap:LinkPinToPin(self.pause_get_node.outputs[1].uid , self.ifelse.inputs[1].uid)

    self.wrap:DeleteBlueLink(self.execlink[BlueDefined.LINK_UID]); -- 删除 tick和setlocalposition之间的节点

    self.wrap:LinkPinToPin(self.tick.execOutputs[1].uid, self.ifelse.execInputs[1].uid)  -- tick -> ifelse
    self.wrap:LinkPinToPin(self.ifelse.execOutputs[2].uid, self.setLocalPosition.execInputs[1].uid) -- ifelse(false) -> setLocalPosition ; ifelse(false) -> nil
    --BlueDumper.dump(self.graph);
    goto CONTINUE
  end
  -------------------------------------------------------------------
  ---- [make array] 创建更多引脚(原来已经有一个引脚)
  if index == 9 then
    WARNING("Create Array And Add More Pin")

    self.makeArrayNode = self.wrap:AddBluePrintNode("bluecore.bluenodes.array.make_array", 408, -208);

    local node = self.makeArrayNode;
    if node:CanCreateMoreInput() then
      local operator = node:GetMoreInputsMethod()
      if operator.add ~= nil then
        LOG("operator "..tostring(operator.add.opname))
        self.makeArrayInput2 = self.wrap:AddNodePin(node.uid, BlueDefined.MORE_INPUT)
        self.makeArrayInput3 = self.wrap:AddNodePin(node.uid, BlueDefined.MORE_INPUT)
        self.makeArrayInput4 = self.wrap:AddNodePin(node.uid, BlueDefined.MORE_INPUT) -- 加上原来的一共有4个输入
      else
        ERROR("[TDD] fail make_array not support add ")
        continue = false;
        BlueDumper.dump(self.graph);
      end
    else
      ERROR("[TDD] fail make_array:CanCreateMoreInput ");
      continue = false ;
      BlueDumper.dump(self.graph);
    end

    --if node:CanCreateMoreOutput() then
    --  local operator = node:GetMoreOutputsMethod()
    --  if operator.add ~= nil then
    --    LOG("operator "..tostring(operator.add.opname))
    --    local make_array_output = self.graph:AddNodePin(node.uid, BlueDefined.MORE_OUTPUT)
    --  else
    --    ERROR("[TDD] fail make_array not support add ")
    --  end
    --else
    --  ERROR("[TDD] fail make_array:CanCreateMoreInput ");
    --  BlueDumper.dump(self.graph);
    --  return
    --end

    -- BlueDumper.dump(self.graph);
    goto CONTINUE
  end
  -------------------------------------------------------------------
  ---- 删除数组引脚(没特化前) pin2 和 pin4 , 留下 pin1和pin3 由于array会重新排序
  if index == 10 then
    WARNING("[TDD] remove array pin2 and pin4 ")
    local node = self.makeArrayNode ;
    if node:CanCreateMoreInput() then
      local operator = node:GetMoreInputsMethod()
      if not self.graph:CanDelete(self.makeArrayInput2.uid) then
        ERROR("[TDD] array pin can not delete ");
        continue = false ;
        BlueDumper.dump(self.graph);
      end

      if operator.del ~= nil then
        local success = self.wrap:DeleteNodePin(self.makeArrayInput2.uid, BlueDefined.MORE_INPUT)
        assert(success, "[TDD] fail to DeleteNodePin 1 ")
        success = self.wrap:DeleteNodePin(self.makeArrayInput4.uid, BlueDefined.MORE_INPUT)
        assert(success, "[TDD] fail to DeleteNodePin 3 ")

        -- bad case 重复删除
        success = self.wrap:DeleteNodePin(self.makeArrayInput4.uid, BlueDefined.MORE_INPUT)
        assert(not success, "[TDD] duplicate to DeleteNodePin 3 should be not allowed")
      end
    else
      ERROR("[TDD] fail make_array:CanCreateMoreInput ");
      continue = false ;
      BlueDumper.dump(self.graph);
    end

    --BlueDumper.dump(self.graph);
    goto CONTINUE
  end
  ---------------------------------------------------------------------
  ------ 补充数组引脚
  if index == 11 then
    WARNING("[TDD] add array pin2 and pin4  ")
    self.makeArrayInput2 = self.makeArrayInput3
    self.makeArrayInput3 = self.wrap:AddNodePin(self.makeArrayNode.uid, BlueDefined.MORE_INPUT)
    self.makeArrayInput4 = self.wrap:AddNodePin(self.makeArrayNode.uid, BlueDefined.MORE_INPUT)
    if self.makeArrayInput3 == nil or self.makeArrayInput4 == nil then
      ERROR("[TDD] fail to re add pin fail");
      return
    end
    --BlueDumper.dump(self.graph);
    goto CONTINUE
  end
  ---------------------------------------------------------------------
  ---- [make array] any type 与具体类引脚连接
  if index == 12 then
    WARNING("[TDD] link array pin to node ")
    self.ou1 = self.wrap:AddBluePrintNode("bluecore.bluenodes.mathfunction.random.randomscalar", 108, -372);
    self.ou2 = self.wrap:AddBluePrintNode("bluecore.bluenodes.mathfunction.random.randomscalar", 108, -292);
    self.ou3 = self.wrap:AddBluePrintNode("bluecore.bluenodes.mathfunction.random.randomscalar", 108, -202);
    self.ou4 = self.wrap:AddBluePrintNode("bluecore.bluenodes.mathfunction.random.randomscalar", 108, -132);

    self.wrap:LinkPinToPin(self.ou1.outputs[1].uid, self.makeArrayInput4.uid)
    --BlueDumper.dump(self.graph);
    goto CONTINUE
  end
  -------------------------------------------------------------------
  ---- [make array] 完成array所有引脚连接
  if index == 13 then
    WARNING("[TDD] link array pin to node ")
    self.wrap:LinkPinToPin(self.ou2.outputs[1].uid, self.makeArrayInput2.uid)
    self.wrap:LinkPinToPin(self.ou3.outputs[1].uid, self.makeArrayInput3.uid)
    self.wrap:LinkPinToPin(self.ou4.outputs[1].uid, self.makeArrayNode.inputs[1].uid)
    --BlueDumper.dump(self.graph);
    goto CONTINUE
  end
  -------------------------------------------------------------------
  ---- [make array] 删除 与make array 单个输入,所有引脚应该还是特化类型
  if index == 14 then
    WARNING("[TDD] delete one node linked to array ")
    self.wrap:DeleteBlueNode(self.ou1.uid)
    --BlueDumper.dump(self.graph);
    goto CONTINUE
  end
  -------------------------------------------------------------------
  ---- [make array] 删除 所有array相关输入 ,应该make array恢复为any type
  if index == 15 then
    WARNING("[TDD] delete all nodes linked to array ")
    self.wrap:DeleteBlueNode(self.ou2.uid)
    self.wrap:DeleteBlueNode(self.ou3.uid)
    self.wrap:DeleteBlueNode(self.ou4.uid)
    --BlueDumper.dump(self.graph);
    goto CONTINUE
  end
  -------------------------------------------------------------------
  ---- [make array] 重新创建与make array的输入
  if index == 16 then
    WARNING("[TDD] recreate all nodes linked to array")
    self.ou11 = self.wrap:AddBluePrintNode("bluecore.bluenodes.mathfunction.random.randomscalar", 108, -372);
    self.ou21 = self.wrap:AddBluePrintNode("bluecore.bluenodes.mathfunction.random.randomscalar", 108, -292);
    self.ou31 = self.wrap:AddBluePrintNode("bluecore.bluenodes.mathfunction.random.randomscalar", 108, -202);
    self.ou41 = self.wrap:AddBluePrintNode("bluecore.bluenodes.mathfunction.random.randomscalar", 108, -132);
    self.ln1 = self.wrap:LinkPinToPin(self.ou11.outputs[1].uid, self.makeArrayInput2.uid)
    self.ln2 = self.wrap:LinkPinToPin(self.ou21.outputs[1].uid, self.makeArrayInput3.uid)
    self.ln3 = self.wrap:LinkPinToPin(self.ou31.outputs[1].uid, self.makeArrayInput4.uid)
    self.ln4 = self.wrap:LinkPinToPin(self.ou41.outputs[1].uid, self.makeArrayNode.inputs[1].uid)
    --BlueDumper.dump(self.graph);
    goto CONTINUE
  end
  -------------------------------------------------------------------
  ---- [make array] 删除 与make array相关的连线,应该make array恢复为any type
  if index == 17 then
    WARNING("[TDD] remove all links linked to array")
    self.wrap:DeleteBlueLink(self.ln1.uid)
    self.wrap:DeleteBlueLink(self.ln2.uid)
    self.wrap:DeleteBlueLink(self.ln3.uid)
    self.wrap:DeleteBlueLink(self.ln4.uid)
    --BlueDumper.dump(self.graph);
    goto CONTINUE
  end
  -------------------------------------------------------------------
  ---- [make array] 恢复连接
  if index == 18 then
    WARNING("[TDD] relink all links linked to array")
    self.wrap:LinkPinToPin(self.ou11.outputs[1].uid, self.makeArrayInput2.uid)
    self.wrap:LinkPinToPin(self.ou21.outputs[1].uid, self.makeArrayInput4.uid)
    self.wrap:LinkPinToPin(self.ou31.outputs[1].uid, self.makeArrayInput3.uid) -- 注意 顺序故意修改了一下
    self.wrap:LinkPinToPin(self.ou41.outputs[1].uid, self.makeArrayNode.inputs[1].uid)
    --BlueDumper.dump(self.graph);
    goto CONTINUE
  end
  -------------------------------------------------------------------
  ---- [For Loop break] 创建for loop 并连接 数组输出
  if index == 19 then
    WARNING("[TDD] create For-Loop-Break logic")
    self.forloop = self.wrap:AddBluePrintNode("bluecore.bluenodes.controlflow.forloopbreak", 418, 204);
    self.for_array_lnk = self.wrap:LinkPinToPin(self.forloop.inputs[1].uid, self.makeArrayNode.outputs[1].uid)
    --BlueDumper.dump(self.graph);
    goto CONTINUE
  end
  -------------------------------------------------------------------
  ------- [For Loop break] 删除连接  应该for each类型恢复any 但是array保持
  if index == 20 then
    WARNING("[TDD] unlink For-Loop-Break input")
    self.wrap:DeleteBlueLink(self.for_array_lnk[BlueDefined.LINK_UID])
    --BlueDumper.dump(self.graph);
    goto CONTINUE
  end
  -------------------------------------------------------------------
  ------- [For Loop break] 恢复连接
  if index == 21 then
    WARNING("[TDD] link For-Loop-Break input")
    self.for_array_link = self.wrap:LinkPinToPin(self.forloop.inputs[1].uid, self.makeArrayNode.outputs[1].uid)  -- array -> for-array
    --BlueDumper.dump(self.graph);
    goto CONTINUE
  end
  -------------------------------------------------------------------
  ------- [For Loop break]
  if index == 22 then
    WARNING("[TDD] create noless node")
    self.noless = self.wrap:AddBluePrintNode("bluecore.bluenodes.mathfunction.equation.float.noless", 719, 416);
    self.wrap:SetInputPinLiteral(self.noless.inputs[2].uid, 3); -- 数组有4个元素  >=3 也就是执行完第3个元素后会break

    self.printElement = self.wrap:AddBluePrintNode("bluecore.bluenodes.utility.print", 1096, 160);
    self.printIndex   = self.wrap:AddBluePrintNode("bluecore.bluenodes.utility.print", 1032, 396);
    self.printComplete = self.wrap:AddBluePrintNode("bluecore.bluenodes.utility.print", 824, 220);
    self.wrap:SetInputPinLiteral(self.printComplete.inputs[1].uid, "Complete");
    --BlueDumper.dump(self.graph);
    goto CONTINUE
  end
  -------------------------------------------------------------------
  ------- [For Loop break] 完整连接
  if index == 23 then
    WARNING("[TDD] link For-Loop-Break all pins")
    self.ifelse2 = self.wrap:AddBluePrintNode("bluecore.bluenodes.controlflow.ifelse", 776, 692);

    ---- 执行流
    self.wrap:LinkPinToPin(self.forloop.execOutputs[1].uid, self.printElement.execInputs[1].uid) -- for-loop -> print
    self.wrap:LinkPinToPin(self.printElement.execOutputs[1].uid, self.printIndex.execInputs[1].uid)
    self.wrap:LinkPinToPin(self.printIndex.execOutputs[1].uid, self.ifelse2.execInputs[1].uid)
    self.wrap:LinkPinToPin(self.ifelse2.execOutputs[1].uid, self.forloop.execInputs[2].uid)

    self.wrap:LinkPinToPin(self.forloop.execOutputs[2].uid, self.printComplete.execInputs[1].uid) -- for-complete -> print

    ---- 数据流
    self.element_link = self.wrap:LinkPinToPin(self.forloop.outputs[1].uid, self.printElement.inputs[1].uid) -- for array elemenet
    self.wrap:LinkPinToPin(self.forloop.outputs[2].uid, self.printIndex.inputs[1].uid) -- for array index

    self.wrap:LinkPinToPin(self.forloop.outputs[2].uid, self.noless.inputs[1].uid) -- for array index -> noless (>=2)
    self.wrap:LinkPinToPin(self.noless.outputs[1].uid, self.ifelse2.inputs[1].uid) --> noless -> ifelse

    ---- 执行
    self.wrap:LinkPinToPin(self.ifelse.execOutputs[1].uid, self.forloop.execInputs[1].uid)

    --BlueDumper.dump(self.graph);
    goto CONTINUE
  end
  -------------------------------------------------------------------
  ------- [For Loop break] 删除 array element 输出引脚 应该不会anytype
  if index == 24 then
    WARNING("[TDD] unlink For-Loop-Break output element pin")
    self.wrap:DeleteBlueLink(self.element_link[BlueDefined.LINK_UID]);
    --BlueDumper.dump(self.graph);
    goto CONTINUE
  end
  -------------------------------------------------------------------
  ------- [For Loop break] 删除 array 输入 应该会anytype
  if index == 25 then
    WARNING("[TDD] unlink For-Loop-Break input array pin")
    self.wrap:DeleteBlueLink(self.for_array_link[BlueDefined.LINK_UID]);
    --BlueDumper.dump(self.graph);
    goto CONTINUE
  end
  -------------------------------------------------------------------
  ------- [For Loop break] 恢复 应该没有特化
  if index == 26 then
    WARNING("[TDD] link For-Loop-Break output to print ")
    self.wrap:LinkPinToPin(self.forloop.outputs[1].uid, self.printElement.inputs[1].uid)
    --BlueDumper.dump(self.graph);
    goto CONTINUE
  end
  -------------------------------------------------------------------
  ------- [For Loop break] 恢复 特化  print也特化 ?
  if index == 27 then
    WARNING("[TDD] link For-Loop-Break input from Make-Array ")
    self.wrap:LinkPinToPin(self.forloop.inputs[1].uid, self.makeArrayNode.outputs[1].uid)
    --BlueDumper.dump(self.graph);
    --goto CONTINUE -- end
  end

  continue = false

  WARNING("");
  WARNING("");
  WARNING("End Demo")

  ::CONTINUE::

  return continue
end

function BlueDemo:_GetGameInstance()

  local Editor = require "window.editor.system.editsystem"
  local Command = require "window.editor.command.command"

  local game = Editor:GetGameScene()

  local cmd = Command();
  cmd:SetSceneID(game:GetStaticID())
  local blueComGame =  cmd:GetContent(self.wrap:GetContentPath())

  local blueprint = blueComGame.Instances[BlueDefined.LuaPath];

  assert(blueprint, "[_GetGameInstance] blueprint in game not found ");

  return blueprint
end

return BlueDemo;