local venuscore = require "venuscore"
local AE = require "apolloengine"
local mathfunction = require "mathfunction"
local apollodefine = require "apolloengine.defined"
local BD = require "bluecore.bluedefined"
local ED = require "bluecore.eventdispatcher" 
local TC = require "bluecore.base.transaction_center"

local VenusCache = AE.VenusCache
local ScreenTouchBehavior = venuscore.VenusBehavior:extend("ScreenTouchBehavior");

ScreenTouchBehavior:MemberRegister("position");
ScreenTouchBehavior:MemberRegister("scale");
ScreenTouchBehavior:MemberRegister("rotate");

ScreenTouchBehavior:MemberRegister("reversePosX");
--Mark 因为蓝图节点的touch信号链路与此behavior的一致 按照产品要求 只有touch信号客户端不会触发引导动画

--FIXME旋转:设素材初始状态为正(如果以屏幕的直立为正会有计算问题)   
--记录增量欧拉角判断是否需要吸附  Venus缓存存储node旋转的欧拉角增量对应的四元数  
--恢复的时候转回增量欧拉角
--Mark:不能用四元转欧拉再转四元计算步骤 容易出问题

function ScreenTouchBehavior:new()
  self.position = true;
  self.scale = true;
  self.rotate = true;

  self.reversePosX = false;
  self.originXY = mathfunction.vector2(0,0); --不考虑z值

  self.camera = nil;
  self.transactionId = -1;
  self.stickerPath = nil;

  self.thresholdAngle = 10.0 * math.pi / 180.0;
  self.isstartRotateLean = false; 
  self.isOverStraight = false; --初始是非倾斜状态  旋转时是否越过临界角度
  --初始旋转是否倾斜状态  如果是倾斜状态  那靠近直立的时候一定吸附
  --如果是直立状态  超过临界角度以后回来则开始吸附
  self.isAllowVibrate = false; --是否允许发送振动请求

  --self.count = 0.0;
  self.rotateSum = 0.0;

end

function ScreenTouchBehavior:GetCamera()
  return self.camera;
end


function ScreenTouchBehavior:SetCamera(camera)
  self.camera = camera;
end

function ScreenTouchBehavior:_IsTimeOut(deltaMs)
  return true; -- TC Update时返回true调用Clear函数
end

function ScreenTouchBehavior:_TimeOut()
end

function ScreenTouchBehavior:_Ready(jsonData)
  return false;  --客户端不push回来
end

function ScreenTouchBehavior:SetOriginPosition(params)
  self.originXY = params.point;
end

function ScreenTouchBehavior:_PositionFromScreenToWorld(pos)
  --[[local zNear = 0;
  if self.camera.ProjectionType == 2.0 then --正交
    zNear = -1.0;
  end
  local rayb = mathfunction.vector4(pos.mx, pos.my, zNear, 1.0);
  local raye = mathfunction.vector4(pos.mx, pos.my, 1.0, 1.0);
  local hostNodeTrans = self.Node:GetComponent(AE.Node.CT_TRANSFORM);
  local hostNodePos = hostNodeTrans:GetWorldPosition();
  local cameraViewProj = self.camera:GetViewProj();
  local cameraViewProjInv = cameraViewProj:Inverse();
  rayb = rayb * cameraViewProjInv;
  raye = raye * cameraViewProjInv;
  if self.camera.ProjectionType ~= 2.0 then
    rayb = rayb / rayb.mw;
    raye = raye / raye.mw; 
  end
  local t = (hostNodePos.mz - rayb.mz)/(raye.mz - rayb.mz);
  local newHostNodePos = mathfunction.vector3(rayb.mx + t*(raye.mx - rayb.mx),  rayb.my + t*(raye.my - rayb.my), hostNodePos.mz);
  return newHostNodePos;]]--
  local hostNodeTrans = self.Node:GetComponent(AE.Node.CT_TRANSFORM);
  local hostNodePos = hostNodeTrans:GetWorldPosition();
  local cameraViewProj = self.camera:GetViewProj();
  local cameraViewProjInv = cameraViewProj:Inverse();
  local currentClip = mathfunction.vector4(hostNodePos.mx, hostNodePos.my, hostNodePos.mz, 1.0) * cameraViewProj;
  local newClip = mathfunction.vector4(pos.mx, pos.my, currentClip.mz/currentClip.mw, 1.0);
  local newWorld = newClip * cameraViewProjInv;
  if self.camera.ProjectionType ~= 2.0 then
    newWorld = newWorld / newWorld.mw;
  end
  return mathfunction.vector3(newWorld.mx, newWorld.my, newWorld.mz);
end

function ScreenTouchBehavior:SetNodePosition(params)
  local vec2 = params.point;
  local hostNodeTrans = self.Node:GetComponent(AE.Node.CT_TRANSFORM);
  local hostNodePos = hostNodeTrans:GetWorldPosition();
  local deltaPos = vec2 - self.originXY;
  deltaPos.mx = self.reversePosX and -deltaPos.mx or deltaPos.mx;

  if venuscore.isNil(self.camera) then 
    --2D片不需要选择摄像机 由于2d片quad.shader的vs在xy方向多位移了一倍 这里除以二能够跟着指尖
    hostNodePos = hostNodePos + mathfunction.vector3(deltaPos:x()/2.0, deltaPos:y()/2.0, 0);
  else --3D片
    local newWorldPos = self:_PositionFromScreenToWorld(vec2);
    local originWorldPos = self:_PositionFromScreenToWorld(self.originXY);
    hostNodePos = hostNodePos + newWorldPos - originWorldPos;   
  end

  hostNodeTrans:SetWorldPosition(hostNodePos);
  self.originXY = vec2; --这样就不需要注册release信号了吧
end

function ScreenTouchBehavior:SetNodeScale(params)
  local scale = params.z;
  local hostNodeTrans = self.Node:GetComponent(AE.Node.CT_TRANSFORM);
  local hostNodeScale = hostNodeTrans:GetLocalScale();
  hostNodeScale = mathfunction.vector3(hostNodeScale:x()*scale, hostNodeScale:y()*scale, hostNodeScale:z());
  hostNodeTrans:SetLocalScale(hostNodeScale);
end

function ScreenTouchBehavior:SetNodeRotate(params)
  local rotate = -1.0*params.z/180*math.pi;
  self.rotateSum = self.rotateSum + rotate;
  local hostNodeTrans = self.Node:GetComponent(AE.Node.CT_TRANSFORM);
  local worldrot = hostNodeTrans:GetWorldRotation();
  local deltarot = mathfunction.Quaternion(); 
  deltarot:RotateXYZ(0,0,rotate); --传入弧度
 
  local eular = 0.0;
  local remainder = self.rotateSum %  (math.pi/2);
  if self.isStartRotateLean then --如果开始旋转的时候初始角度是倾斜的 角度靠近临界值就需要吸附 
    --客户端传入角度和如果靠近90度的倍数(允许10度偏差)则进行吸附
    if remainder < self.thresholdAngle or remainder > math.pi/2.0 - self.thresholdAngle then 
      eular = remainder > math.pi/2.0 - self.thresholdAngle and math.pi/2.0 - remainder or -remainder;
      self.rotateSum = self.rotateSum + eular;
      deltarot:RotateXYZ(0, 0, rotate + eular); 
      --ERROR("isStartRotateLean RotateXYZ "..tostring(eular));
      if self.transactionId ~= -1 and self.isAllowVibrate  then
        TC:Request(self, self.transactionId, BD.RequestType.VIBRATE, 0, "{}");
        self.isAllowVibrate = false; --不连续发送振动请求
      end
    else
      self.isAllowVibrate = true;
    end
  else  --如果初始是非倾斜状态
    if self.isOverStraight then --非倾斜状态旋转时角度一旦超过临界值  则需要判断当前计算的角度是否在临界值内 在则需要吸附
      if remainder < self.thresholdAngle or remainder > math.pi/2.0 - self.thresholdAngle then
        eular = remainder > math.pi/2.0 - self.thresholdAngle and math.pi/2.0 - remainder or -remainder;
        self.rotateSum = self.rotateSum + eular;
        deltarot:RotateXYZ(0, 0, rotate + eular);
        --ERROR(" RotateXYZ "..tostring(rotate+eular));
        --初始为非倾斜状态吸附了以后不再允许角度在临界值以内(不松手的情况下)
        if self.transactionId ~= -1 and self.isAllowVibrate then
          TC:Request(self, self.transactionId, BD.RequestType.VIBRATE, 0, "{}");
          self.isAllowVibrate = false; --不连续发送振动请求
        end
      else
        self.isAllowVibrate = true;
      end
    else
      if remainder > self.thresholdAngle and remainder < math.pi/2.0 - self.thresholdAngle then
        self.isOverStraight = true;
      end
    end
  end

  worldrot = worldrot*deltarot;
  hostNodeTrans:SetWorldRotation(worldrot);

end

function ScreenTouchBehavior:SetRotateStart()
  local hostNodeTrans = self.Node:GetComponent(AE.Node.CT_TRANSFORM);
  local worldrot = hostNodeTrans:GetWorldRotation();
  local eular = worldrot:ToEulerAngle();
  local remainder = eular.mz %  (math.pi/2);
  self.isStartRotateLean =  remainder > self.thresholdAngle and remainder < math.pi/2.0 - self.thresholdAngle;
end

function ScreenTouchBehavior:SetRotateEnd()
  self.isStartRotateLean = false;
  self.isOverStraight = false;
  self.isAllowVibrate = false;
end


function ScreenTouchBehavior:_OnAwake()
  self.stickerPath = venuscore.IFileSystem:PathAssembly("proj:");
  local scriptCom = self.Node:GetComponent(AE.Node.CT_SCRIPT);
  if self.position then
    AE.IActionSystem:AddClient(
      AE.SensorsTrackingComponent.VENUS_SENSOR_TOUCH, --其实并没有用到SensorTracking~
      scriptCom, 0);
    --编辑器模式下暂时不注册回调（编辑器不支持触摸控制）
    if not _KRATOSEDITOR then
      ED:RegisterCallback(
              BD.Event.TouchGlobalPath, --理解成TouchComponent(其实没有这Component)全局唯一
              BD.Event.TouchGlobalEvent.TOUCH_PRESS ,
              self.SetOriginPosition,
              self);
      ED:RegisterCallback(
              BD.Event.TouchGlobalPath,
              BD.Event.TouchGlobalEvent.TOUCH_MOVE ,
              self.SetNodePosition,
              self);
      local cachePos = VenusCache:GetStickerPositionCache(self.stickerPath);
      if cachePos then
        local transCom = self.Node:GetComponent(AE.Node.CT_TRANSFORM);
        transCom:SetLocalPosition(cachePos);
        VenusCache:ClearStickerPositionCachee(self.stickerPath);
      end
    end
  end
  if self.scale then
    AE.IActionSystem:AddClient(
      AE.SensorsTrackingComponent.VENUS_SENSOR_GESTURE_SCALE,
      scriptCom, 0);
    if not _KRATOSEDITOR then
      ED:RegisterCallback(
              BD.Event.GestureScalePath,
              BD.Event.GestureGlobalEvent.GESTURE_KEEP,
              self.SetNodeScale,
              self);
      local cacheScale = VenusCache:GetStickerScaleCache(self.stickerPath);
      if cacheScale then
        local transCom = self.Node:GetComponent(AE.Node.CT_TRANSFORM);
        transCom:SetLocalScale(cacheScale);
        VenusCache:ClearStickerScaleCache(self.stickerPath);
      end
    end
  end
  if self.rotate then
    AE.IActionSystem:AddClient(
      AE.SensorsTrackingComponent.VENUS_SENSOR_GESTURE_ROTATE,
      scriptCom, 0);
    AE.IActionSystem:AddClient(
      AE.SensorsTrackingComponent.VALUE_GESTURE_BEGIN,
      scriptCom, 0);
    AE.IActionSystem:AddClient(
      AE.SensorsTrackingComponent.VALUE_GESTURE_END,
      scriptCom, 0);
    if not _KRATOSEDITOR then
      ED:RegisterCallback(
            BD.Event.GestureRotatePath,
            BD.Event.GestureGlobalEvent.GESTURE_KEEP,
            self.SetNodeRotate,
            self);
      ED:RegisterCallback(
            BD.Event.GestureRotatePath,
            BD.Event.GestureGlobalEvent.GESTURE_BEGIN,
            self.SetRotateStart,
            self);
      ED:RegisterCallback(
            BD.Event.GestureRotatePath,
            BD.Event.GestureGlobalEvent.GESTURE_END,
            self.SetRotateEnd,
            self);
      local cacheRotate = VenusCache:GetStickerRotationache(self.stickerPath);  
      if cacheRotate then
        local transCom = self.Node:GetComponent(AE.Node.CT_TRANSFORM);
        local originWorldEuler = transCom:GetWorldRotation();
        self.rotateSum = cacheRotate:ToEulerAngle().mz;
        transCom:SetWorldRotation(originWorldEuler*cacheRotate);
        VenusCache:ClearStickerRotationache(self.stickerPath);
      end
      self.transactionId = self:_CreateTransactionId();
    end
  end
end


function ScreenTouchBehavior:_OnDestroy()
  if not _KRATOSEDITOR then
    ED:DeregisterCallback(self);
    if self.transactionId ~= -1 then
      TC:Clear(self.transactionId)
    end
  end
  local scriptCom = self.Node:GetComponent(AE.Node.CT_SCRIPT);
  local transCom = self.Node:GetComponent(AE.Node.CT_TRANSFORM);
  if self.position then
    AE.IActionSystem:RemoveClient(
            AE.SensorsTrackingComponent.VENUS_SENSOR_TOUCH,
            scriptCom);
    VenusCache:PushStickerPositionCache(self.stickerPath, transCom:GetLocalPosition());
  end
  if self.scale then
    AE.IActionSystem:RemoveClient(
            AE.SensorsTrackingComponent.VENUS_SENSOR_GESTURE_SCALE,
            scriptCom);
    VenusCache:PushStickerScaleCache(self.stickerPath, transCom:GetLocalScale());
  end
  if self.rotate then
    AE.IActionSystem:RemoveClient(
            AE.SensorsTrackingComponent.VENUS_SENSOR_GESTURE_ROTATE,
            scriptCom);
    AE.IActionSystem:RemoveClient(
            AE.SensorsTrackingComponent.VALUE_GESTURE_BEGIN,
            scriptCom);
    AE.IActionSystem:RemoveClient(
            AE.SensorsTrackingComponent.VALUE_GESTURE_END,
            scriptCom);
    local quatToSave = mathfunction.Quaternion();
    quatToSave:RotateXYZ(0,0,self.rotateSum);
    VenusCache:PushStickerRotationache(self.stickerPath, quatToSave);

  end
end


function ScreenTouchBehavior:_OnUpdate(def)

end

function ScreenTouchBehavior:_CreateTransactionId()
  local count = 1.0;
  for i = 1, 10 do
    local tId = math.ceil(math.random() * 1000000);
    if not TC:HasTransaction(tId) then
      return tId;
    end
  end
  return -1;
end


ScreenTouchBehavior:MemberRegister("camera",
  venuscore.ScriptTypes.ReferenceType(
    AE.CameraComponent:RTTI(),    
    ScreenTouchBehavior.GetCamera,
    ScreenTouchBehavior.SetCamera
)); 




return ScreenTouchBehavior;