require "utility"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"

local pixelcut = {}
pixelcut.renderObject = nil;
pixelcut.material = nil;
pixelcut.queue = 313;

function pixelcut:Initialize(host, size)
  
  
  self.X_CUT_SIZE = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,"X_CUT_SIZE");
  self.Y_CUT_SIZE = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,"Y_CUT_SIZE");

  self.material = host:CreateMaterial("comm:documents/material/pixelcut.material" );
  self.renderObject = host:CreateRenderObject();
  self.material:SetParameter(self.X_CUT_SIZE, mathfunction.vector1(0.99) );
  self.material:SetParameter(self.Y_CUT_SIZE, mathfunction.vector1(1.0) );

  
  return self.queue;

end



function pixelcut:Resizeview(size)
  
end



function pixelcut:Process(context, Original, Scene, Output)
  
    context:BeginRenderPass(Output, apolloengine.RenderTargetEntity.CF_COLOR);
    self.material:SetParameter(
    apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
    Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
    context:Draw(self.renderObject, self.material);
    context:EndRenderPass();
    
end

return pixelcut;
