
#DEFPARAMS
_MainTex = { "main Color", TEXTURE2D, "maintex" },
_BlendTex = { "Blend Texture", TEXTURE2D, "blendtex"},
_BlendMode = {"Blend Mode", FLOAT, "1.0"},
_BlendOpacity = {"Blend Opacity", FLOAT, "1.0"},
#END

#DEFTAG
ShaderName = "BlendMode"
RenderQueue = "Opaque"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"
#include "blendfunc.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

Texture2D _MainTex;
Texture2D _BlendTex;
SamplerState _MainTexSampler;
SamplerState _BlendTexSampler;
float     _BlendMode;
float     _BlendOpacity;


v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv.xy;

	return o;
}

void frag(in v2f i, out float4 outColor : SV_Target0)
{
  float4 mainColor = _MainTex.Sample(_MainTexSampler,i.uv);
  float4 blendColor = _BlendTex.Sample(_BlendTexSampler,i.uv);
  //float3 mainRGB = float3(mainColor.r,mainColor.g,mainColor.b);
  //float3 blendRGB = float3(blendColor.r,blendColor.g,blendColor.b);
  
  float3 blendR = float3(1.0,0.0,0.0);
  int iBlendMode = int(_BlendMode + 0.5);
  if (_BlendOpacity >= 1.0){
    blendR = blend(iBlendMode,mainColor,blendColor);
  }else {
    blendR = blend( iBlendMode, mainColor, blendColor, _BlendOpacity );
  }
  //return blendColor;
  outColor = float4(blendR.r,blendR.g,blendR.b,1.0);
}
ENDCG
#END
