#pragma once

float3 rgb2hsv(float3 c)
{
    float4 K = float4(0.0, -1.0 / 3.0, 2.0 / 3.0, -1.0);
    float4 p = lerp(float4(c.bg, K.wz), float4(c.gb, K.xy), step(c.b, c.g));
    float4 q = lerp(float4(p.xyw, c.r), float4(c.r, p.yzx), step(p.x, c.r));

    float d = q.x - min(q.w, q.y);
    float e = 1.0e-10;
    float v = q.x;
    float h = d <= e ? 0.0 : abs(q.z + (q.w - q.y) / (6.0 * d));
    float s = d <= e ? 0.0 : d / v;
    s = v <= 0.3 ? s * (v / 0.3) : s;
    return clamp(float3(h, s, v), 0.0, 1.0);
}

float3 hsv2rgb(float3 c)
{
    float4 K = float4(1.0, 2.0 / 3.0, 1.0 / 3.0, 3.0);
    float3 p = abs(frac(c.xxx + K.xyz) * 6.0 - K.www);
    return clamp(c.z * lerp(K.xxx, clamp(p - K.xxx, 0.0, 1.0), c.y), 0.0, 1.0);
}


float3 hsv2hsl(float3 c) {
    float l = c.z - c.z * c.y * 0.5;
    float e = 1.0e-10;
    float m = min(l, 1.0 - l);
    float s = m <= e ? 0.0 : (c.z - l) / m;
    return float3(c.x, s, l);
}

float3 hsl2hsv(float3 c) {
    float v = c.z + c.y * min(c.z, 1.0 - c.z);
    float e = 1.0e-10;
    float s = v <= e ? 0.0 : 2.0 * (v - c.z) / v;
    return float3(c.x, s, v);
}
