

#DEFPARAMS
COLOR_DARK = { "colorDark", VEC3, "255, 0, 0"},
COLOR_MIDDLE = { "colorMiddle", VEC3, "0, 255, 0"},
COLOR_LIGHT = { "colorLight", VEC3, "0, 0, 255"},
BLEND_FACTOR = { "blendFactor", FLOAT, "100"},
[Keywords(POST_EFFECT_ALPHA_ON, POST_EFFECT_ALPHA_OFF)]
POST_EFFECT_ALPHA = {"post_effect_alpha", FLOAT, "0.0"},
#END

#DEFTAG
ShaderName = "tunes"
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK   = COLOR_RGBA
ALPAH_MODE   = { ALPAH_OFF }
DRAW_MODE    = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#pragma multi_compile POST_EFFECT_ALPHA_ON POST_EFFECT_ALPHA_OFF
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

Texture2D TEXTURE_DIFFUSE;
SamplerState TEXTURE_DIFFUSE_Sampler;
float3 COLOR_DARK;
float3 COLOR_MIDDLE;
float3 COLOR_LIGHT;
float BLEND_FACTOR;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex); 
	o.uv = v.uv.xy;

	return o;
}

void frag(in v2f i, out float4 mainColor : SV_Target0)
{
  const float pi = 3.14159265359;

  float4 originColor = TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, i.uv);
  float luma = 0.2989 * originColor.r + 0.5870 * originColor.g + 0.1140 * originColor.b; 

  float factorCos = cos(luma * 2.0 * pi) * 0.5 + 0.5;
  bool beingDark = luma < 0.5;
  float factorDark = beingDark ? factorCos : 0.0;
  float factorLight = beingDark ? 0.0 : factorCos;
  float factorMiddle = 1.0 - factorCos;

  float3 colorTunes = COLOR_DARK * factorDark + COLOR_MIDDLE * factorMiddle + COLOR_LIGHT * factorLight;
  colorTunes = clamp(colorTunes, 0.0, 1.0);
  float3 colorMix = originColor.rgb * BLEND_FACTOR + colorTunes * (1.0 - BLEND_FACTOR);
  colorMix = clamp(colorMix, 0.0, 1.0);

  #ifdef POST_EFFECT_ALPHA_OFF
    mainColor = float4(colorMix, 1.0);
  #elif POST_EFFECT_ALPHA_ON
    mainColor = float4(colorMix, originColor.a);
  #endif
}
ENDCG
#END
