//////////////////////////////////////////////////////////////////////////////////////
//
//						The Bohge Engine License (BEL)
//
//	Copyright (c) 2011-2014 Peng Zhao
//
//	Permission is hereby granted, free of charge, to any person obtaining a copy
//	of this software and associated documentation files (the "Software"), to deal
//	in the Software without restriction, including without limitation the rights
//	to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//	copies of the Software, and to permit persons to whom the Software is
//	furnished to do so, subject to the following conditions:
//
//	The above copyright notice and this permission notice shall be included in
//	all copies or substantial portions of the Software. And the logo of
//	Bohge Engine shall be displayed full screen for more than 3 seconds
//	when the software is started. Copyright holders are allowed to develop
//	game edit based on Bohge Engine, The edit must be released under the MIT
//	open source license if it is going to be published. In no event shall
//	copyright holders be prohibited from using any code of Bohge Engine
//	to develop any other analogous game engines.
//
//	THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//	IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//	FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//	AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//	LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//	OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
//
//////////////////////////////////////////////////////////////////////////////////////


#SHADER_DEFINE Texture2DSampling

  FUNCTION_INPUT =
  {
      { ATTRIBUTE_COORDNATE0,			MEDIUM,		VEC2,					"in_Coordinate" },
			{ TEXTURE_DIFFUSE,			  NONE,			TEXTURE2D,		"diffuseMap" },
  }
  FUNCTION_OUTPUT =
  {
      { ALBEDO_COLOR,          MEDIUM,   VEC4,         "diffuseColor"}
  }
#SHADER_CODE
	vec4 tex = texture2D(diffuseMap, in_Coordinate);
  vec4 diffuseColor = tex;
  if(tex.a < 0.5)
    discard;
#END_CODE
#END_DEFINE


//计算头发的直接光照
#SHADER_DEFINE HairLighting

  FUNCTION_INPUT =
  {
    { TANGENT_DIRECTION,        MEDIUM, VEC3,   "tangentDir"},
    { TANGENTSPACE_VIEWDIRECTION,	HIGH, 	VEC3,	  "viewDirection" },
    { TANGENTSPACE_LIGHTDIRECTION,    MEDIUM,		VEC3,		"lightDirection"},
    { LIGHT_COLOR, 							MEDIUM,		VEC3,					"lightColor"},
    { AMBIENT_COLOR,          LOW,  VEC3,           "ambientColor"},
    { ALBEDO_COLOR,          MEDIUM,   VEC4,         "diffuseColor"},
    { ALPHA_R,              MEDIUM,   FLOAT,         "alphaR"},
    { ALPHA_TT,              MEDIUM,   FLOAT,         "alphaTT"},
    { ALPHA_TRT,              MEDIUM,   FLOAT,         "alphaTRT"},
    { BETA_R,              MEDIUM,   FLOAT,         "bR"},
    { BETA_TT,              MEDIUM,   FLOAT,         "bTT"},
    { BETA_TRT,              MEDIUM,   FLOAT,         "bTRT"},
    { YITA_TT,               MEDIUM,   FLOAT,         "yitaTT"},
    { YITA_G,              MEDIUM,   FLOAT,         "yitaG"},
    { INTENSITY_G,              MEDIUM,   FLOAT,         "Ig"},
    { G_ANGLE,              MEDIUM,   FLOAT,         "Gangle"},
    { INTENSITY_R,              MEDIUM,   FLOAT,         "IR"},
    { INTENSITY_TT,              MEDIUM,   FLOAT,         "ITT"},
    { INTENSITY_TRT,              MEDIUM,   FLOAT,         "ITRT"},
    { COLOR_R,              MEDIUM,   VEC3,         "RColor"},
    { COLOR_TT,              MEDIUM,   VEC3,         "TTColor"},
    { COLOR_TRT,              MEDIUM,   VEC3,         "TRTColor"},
  }
  FUNCTION_OUTPUT =
  {
    { LIGHTING_SPECULAR,			MEDIUM,	VEC3,	    	"light_Specular" },
    { LIGHTING_DIFFUSE,          MEDIUM,   VEC3,         "diffuse"},
  }
#SHADER_CODE
  const float PI = 3.1415926;
  const float RAD2ANG = 180.0 / PI;
  const float ANG2RAD = PI / 180.0;

  float MR;
  float MTT;
  float MTRT;
  float NR;
  float NTT;
  float NTRT;

  lightDirection = -lightDirection;

  vec3 tangent = tangentDir;

  float lightVec = dot(lightDirection, tangent);
  float viewVec = dot(viewDirection, tangent);

  float thetah = RAD2ANG * (asin(lightVec) + asin(viewVec)) /2.0;

  // calculate M component
  float sigma = bR;
  float x_mu = thetah - alphaR;
  {
      MR = exp(-(x_mu * x_mu) / (2.0 * sigma * sigma));
  }
  sigma = bTT;
  x_mu = thetah - alphaTT;
  {
      MTT = exp(-(x_mu * x_mu) / (2.0 * sigma * sigma));
  }
  sigma = bTRT;
  x_mu = thetah - alphaTRT;
  {
      MTRT = exp(-(x_mu * x_mu) / (2.0 * sigma * sigma));
  }

  // calculate N component
  vec3 lightPerp = lightDirection - lightVec * tangent;
  vec3 eyePerp = viewDirection - lightVec * tangent;
  float cosphi = dot(eyePerp, lightPerp) / sqrt(dot(lightPerp,lightPerp) + dot(eyePerp,eyePerp));

  float phi = acos(cosphi);
  NR = cos(phi/2.0);

  float phiang = phi * RAD2ANG;
  sigma = yitaTT;
  x_mu = 180.0 - phiang;
  {
      NTT = exp(-(x_mu * x_mu) / (2.0 * sigma * sigma));
  }
  // Glints
  float NG;
  sigma = yitaG;
  x_mu = Gangle - phiang;
  {
      NG = exp(-(x_mu * x_mu) / (2.0 * sigma * sigma));
  }
  NTRT = NG + NR;

  float costhetaD = cos(thetah * ANG2RAD);

  vec3 light_Specular = ( RColor * IR * MR * NR + TTColor * ITT * MTT * NTT + TRTColor * ITRT * MTRT * NTRT ) / (costhetaD * costhetaD);

  vec3 diffuse = diffuseColor.rgb * lightColor * sqrt(max(0.0, 1.0 - lightVec*lightVec));
  
#END_CODE
#END_DEFINE


//输出到片元
#SHADER_DEFINE FragmentOutput

    FUNCTION_INPUT =
    {
			{ LIGHTING_DIFFUSE,				MEDIUM,	VEC3,		"light_Diffuse" },
			{ LIGHTING_SPECULAR,			MEDIUM,	VEC3,		"light_Specular" },
      { LIGHTING_AMBIENT,          LOW,  VEC3,   "light_Ambient"},
      { DIFFUSE_SCALE,          MEDIUM,   FLOAT,        "diffuseScale" },
      { SPECULAR_SCALE,          MEDIUM,   FLOAT,        "specScale" },
    }
    FUNCTION_OUTPUT = { }

#SHADER_CODE
		vec3 color =  light_Specular * 0.3 * specScale + light_Diffuse * diffuseScale + light_Ambient;

		gl_FragColor = vec4(color, 1.0);

#END_CODE
#END_DEFINE



//==============================================================================================加入阴影
//计算头发的直接光照加透明阴影
#SHADER_DEFINE HairLightingShadow

  FUNCTION_INPUT =
  {
	{ WORLDSPACE_NORMAL,         	HIGH,	VEC3,        "in_NormalWS" },
	{ WORLDSPACE_TANGENT,   		HIGH,	VEC3,    	"in_TangentWS"},
    { TANGENT_DIRECTION,        MEDIUM, VEC3,   "tangentDir"},
	{ WORLDSPACE_VIEWDIRECTION,				LOW,			VEC3,					"viewDirection" },

	{ LIGHT_GIVEN_DIRECTION,		MEDIUM,		VEC3,		"lightDirection" },
    { LIGHT_COLOR, 							MEDIUM,		VEC3,					"lightColor"},
    { AMBIENT_COLOR,          LOW,  VEC3,           "ambientColor"},
    { ALBEDO_COLOR,          MEDIUM,   VEC4,         "diffuseColor"},
    { ALPHA_R,              MEDIUM,   FLOAT,         "alphaR"},
    { ALPHA_TT,              MEDIUM,   FLOAT,         "alphaTT"},
    { ALPHA_TRT,              MEDIUM,   FLOAT,         "alphaTRT"},
    { BETA_R,              MEDIUM,   FLOAT,         "bR"},
    { BETA_TT,              MEDIUM,   FLOAT,         "bTT"},
    { BETA_TRT,              MEDIUM,   FLOAT,         "bTRT"},
    { YITA_TT,               MEDIUM,   FLOAT,         "yitaTT"},
    { YITA_G,              MEDIUM,   FLOAT,         "yitaG"},
    { INTENSITY_G,              MEDIUM,   FLOAT,         "Ig"},
    { G_ANGLE,              MEDIUM,   FLOAT,         "Gangle"},
    { INTENSITY_R,              MEDIUM,   FLOAT,         "IR"},
    { INTENSITY_TT,              MEDIUM,   FLOAT,         "ITT"},
    { INTENSITY_TRT,              MEDIUM,   FLOAT,         "ITRT"},
    { COLOR_R,              MEDIUM,   VEC3,         "RColor"},
    { COLOR_TT,              MEDIUM,   VEC3,         "TTColor"},
    { COLOR_TRT,              MEDIUM,   VEC3,         "TRTColor"},
    { SHADOWMAP_COLOR,				HIGH,	VEC4,		"in_TransparentColor" },
  }
  FUNCTION_OUTPUT =
  {
    { LIGHTING_SPECULAR,			MEDIUM,	VEC3,	    	"light_Specular" },
    { LIGHTING_DIFFUSE,          MEDIUM,   VEC3,         "diffuse"},
  }
#SHADER_CODE
  const float PI = 3.1415926;
  const float RAD2ANG = 180.0 / PI;
  const float ANG2RAD = PI / 180.0;

  float MR;
  float MTT;
  float MTRT;
  float NR;
  float NTT;
  float NTRT;

  lightDirection = -lightDirection;

  	vec3 wNormal = normalize(in_NormalWS);
	vec3 wTangent = normalize(in_TangentWS);
	wTangent = normalize(wTangent - dot(wTangent, wNormal) * wNormal);
	vec3 wBiTangent = cross(wNormal, wTangent);
	mat3 out_TBN = mat3(wTangent,wBiTangent,wNormal);
	
  vec3 tangent = out_TBN * tangentDir;

  float lightVec = dot(lightDirection, tangent);
  float viewVec = dot(viewDirection, tangent);

  float thetah = RAD2ANG * (asin(lightVec) + asin(viewVec)) /2.0;

  // calculate M component
  float sigma = bR;
  float x_mu = thetah - alphaR;
  {
      MR = exp(-(x_mu * x_mu) / (2.0 * sigma * sigma));
  }
  sigma = bTT;
  x_mu = thetah - alphaTT;
  {
      MTT = exp(-(x_mu * x_mu) / (2.0 * sigma * sigma));
  }
  sigma = bTRT;
  x_mu = thetah - alphaTRT;
  {
      MTRT = exp(-(x_mu * x_mu) / (2.0 * sigma * sigma));
  }

  // calculate N component
  vec3 lightPerp = lightDirection - lightVec * tangent;
  vec3 eyePerp = viewDirection - lightVec * tangent;
  float cosphi = dot(eyePerp, lightPerp) / sqrt(dot(lightPerp,lightPerp) + dot(eyePerp,eyePerp));

  float phi = acos(cosphi);
  NR = cos(phi/2.0);

  float phiang = phi * RAD2ANG;
  sigma = yitaTT;
  x_mu = 180.0 - phiang;
  {
      NTT = exp(-(x_mu * x_mu) / (2.0 * sigma * sigma));
  }
  // Glints
  float NG;
  sigma = yitaG;
  x_mu = Gangle - phiang;
  {
      NG = exp(-(x_mu * x_mu) / (2.0 * sigma * sigma));
  }
  NTRT = NG + NR;

  float costhetaD = cos(thetah * ANG2RAD);

  vec3 light_Specular = ( RColor * IR * MR * NR + TTColor * ITT * MTT * NTT + TRTColor * ITRT * MTRT * NTRT ) / (costhetaD * costhetaD);
  
  vec3 newlightColor = mix(lightColor,in_TransparentColor.xyz,in_TransparentColor.a);
  
  vec3 diffuse = diffuseColor.rgb * newlightColor * sqrt(max(0.0, 1.0 - lightVec*lightVec));

#END_CODE
#END_DEFINE
