

#DEFPARAMS
#END

#DEFTAG
ShaderName = "Denoise"
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

Texture2D TEXTURE_DIFFUSE;
SamplerState TEXTURE_DIFFUSE_Sampler;
float2 PIXEL_OFFSETS;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv.xy;

	return o;
}

void frag(in v2f i, out float4 mainColor : SV_Target0)
{
	
    float2 square_coordinates[9];
    
    // first row
    square_coordinates[0] = i.uv.xy - PIXEL_OFFSETS.xy;     // upper left corner
    square_coordinates[1] = float2(i.uv.x , i.uv.y - PIXEL_OFFSETS.y);
    square_coordinates[2] = float2(i.uv.x + PIXEL_OFFSETS.x , i.uv.y - PIXEL_OFFSETS.y);     // upper right corner
    
    // second row
    square_coordinates[3] = float2(i.uv.x - PIXEL_OFFSETS.x , i.uv.y);
    square_coordinates[4] = i.uv.xy;
    square_coordinates[5] = float2(i.uv.x + PIXEL_OFFSETS.x , i.uv.y);
    
    // thrid row
    square_coordinates[6] = float2(i.uv.x - PIXEL_OFFSETS.x , i.uv.y + PIXEL_OFFSETS.y);     // lower left corner
    square_coordinates[7] = float2(i.uv.x , i.uv.y + PIXEL_OFFSETS.y); 
    square_coordinates[8] = i.uv.xy + PIXEL_OFFSETS.xy;     // lower right corner

	
    float3 curr = TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler,square_coordinates[4]).xyz;

    float3 pre_1 = TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, square_coordinates[0]).xyz;
    float3 post_1 = TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, square_coordinates[8]).xyz;
   
    float3 pre_2 = TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, square_coordinates[1]).xyz;
    float3 post_2 = TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, square_coordinates[7]).xyz;
    
    float3 pre_3 = TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, square_coordinates[2]).xyz;
    float3 post_3 = TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, square_coordinates[6]).xyz;
    
    float3 pre_4 = TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, square_coordinates[3]).xyz;
    float3 post_4 = TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, square_coordinates[5]).xyz;
    
    float3 diff_1 = post_1 - pre_1;
    float3 sum_1  = post_1 + pre_1;
    float3 diff_2 = post_2 - pre_2;
    float3 sum_2  = post_2 + pre_2;
    float3 diff_3 = post_3 - pre_3;
    float3 sum_3  = post_3 + pre_3;
    float3 diff_4 = post_4 - pre_4;
    float3 sum_4  = post_4 + pre_4;
    
    float3 var_12 = (curr * 2.0 - sum_1) / ((diff_1 * diff_1 * 3000.0) + 8.0) + (curr * 2.0 - sum_2) / ((diff_2 * diff_2 * 3000.0) + 8.0);
    float3 var_34 = (curr * 2.0 - sum_3) / ((diff_3 * diff_3 * 3000.0) + 8.0) + (curr * 2.0 - sum_2) / ((diff_4 * diff_4 * 3000.0) + 8.0);
    
    curr -= (var_12+var_34);
    
    float4 tmpColor;
    tmpColor.w = 1.0;
    tmpColor.x = curr.x;
    tmpColor.y = curr.y;
    tmpColor.z = curr.z;
    
    mainColor = tmpColor;
}
ENDCG
#END
