#SHADER_DEFINE WaterRippleVertex

	FUNCTION_INPUT = 
	{
    { ATTRIBUTE_POSITION, 			HIGH,	VEC4,		"in_Position" },
		{ ATTRIBUTE_COORDNATE0, 		HIGH,	VEC2,		"in_TexCooridate"},
	}
	FUNCTION_OUTPUT =
	{
		{ ATTRIBUTE_COORDNATE0,			HIGH,	VEC2,		"out_TexCooridate" },
	}

#SHADER_CODE
    gl_Position = in_Position;
    vec2 out_TexCooridate = in_TexCooridate.xy;
#END_CODE
#END_DEFINE


#SHADER_DEFINE WaterRippleFragment  

	FUNCTION_INPUT = 
	{
		{ TEXTURE_DIFFUSE,		NONE,	TEXTURE2D,		"uniCurrentTexture" },
    { ATTRIBUTE_COORDNATE0, 		HIGH,	VEC2,		"in_TexCooridate"},
    { COUNT, 		HIGH,	FLOAT,		"count"}
	}

#SHADER_CODE

    float y = in_TexCooridate.y;
    float x = 0.5*sin(9.42*y);
    vec2 coord = in_TexCooridate+vec2(x,0.0);
    vec3 rgb = step(1.0,coord.x)*(texture2D(uniCurrentTexture, vec2(1.0-x,in_TexCooridate.y)).rgb)+(1.0-step(1.0,coord.x))*(texture2D(uniCurrentTexture,coord).rgb); 
    gl_FragColor = step(1.0,abs(sin(count)))*vec4(vec3(rgb),1.0)+(1.0-step(1.0,abs(sin(count))))*vec4(texture2D(uniCurrentTexture,in_TexCooridate).rgb,1.0);
    // step function doesn't return bool value
    
#END_CODE
#END_DEFINE