
#DEFPARAMS
TEXTURE_DIFFUSE = { "main Color", TEXTURE2D, "maintex" },
FBO_SIZE = {"FBO Size", VEC2, "2048, 2048"},
#END

#DEFTAG
ShaderName = "sdf_blur"
RenderQueue = "Transparent"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, ONE, ZERO, ONE, ZERO }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "commonvar.inc"
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
    float2 uv : TEXCOORD0;
    float4 vertex : SV_POSITION;
};

Texture2D TEXTURE_DIFFUSE;
SamplerState TEXTURE_DIFFUSE_Sampler;
float2 FBO_SIZE;

v2f vert(appdata v)
{
	v2f o;
	float4 pos = v.vertex * (1.0 / v.vertex.w);
	pos = mul(pos, LOCALWORLD_TRANSFORM);
	pos.w = 1.0;
	pos.x = pos.x + WORLD_POSITION.x;
	pos.y = pos.y + WORLD_POSITION.y;
	o.vertex = pos;
  o.vertex = UniformNDC(o.vertex);
	//o.vertex = v.vertex;
	o.uv = v.uv.xy;

    return o;
}

float unpack16 (float2 color) {
    return dot(color , float2(1.0/256., 1.));
}

float2 pack16 (float value) {
    float2 comp = frac(value * float2(256., 1.));
    comp -= comp.xx * float2(0., 1./256.);
    return comp;
}

void frag(in v2f i, out float4 mainColor : SV_Target0)
{
    float offsetx = 1. / FBO_SIZE.x;
    float offsety = 1. / FBO_SIZE.y;
    
    float x0 = i.uv.x - offsetx - offsetx;
    float x1 = x0 + offsetx;
    float x2 = x1 + offsetx;
    float x3 = x2 + offsetx;
    float x4 = x3 + offsetx;

    float y0 = i.uv.y -  offsety - offsety;
    float y1 = y0 + offsety;
    float y2 = y1 + offsety;
    float y3 = y2 + offsety;
    float y4 = y3 + offsety;

    float distance = 0.0;
    float2 dist = TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, float2(x2, y2)).rg;

    distance += unpack16(TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, float2(x0, y0)).rg);
    distance += unpack16(TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, float2(x1, y0)).rg);
    distance += unpack16(TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, float2(x2, y0)).rg);
    distance += unpack16(TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, float2(x3, y0)).rg);
    distance += unpack16(TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, float2(x4, y0)).rg);

    distance += unpack16(TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, float2(x0, y1)).rg);
    distance += unpack16(TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, float2(x1, y1)).rg);
    distance += unpack16(TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, float2(x2, y1)).rg);
    distance += unpack16(TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, float2(x3, y1)).rg);
    distance += unpack16(TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, float2(x4, y1)).rg);

    distance += unpack16(TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, float2(x0, y2)).rg);
    distance += unpack16(TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, float2(x1, y2)).rg);
    distance += unpack16(dist);
    distance += unpack16(TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, float2(x3, y2)).rg);
    distance += unpack16(TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, float2(x4, y2)).rg);

    distance += unpack16(TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, float2(x0, y3)).rg);
    distance += unpack16(TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, float2(x1, y3)).rg);
    distance += unpack16(TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, float2(x2, y3)).rg);
    distance += unpack16(TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, float2(x3, y3)).rg);
    distance += unpack16(TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, float2(x4, y3)).rg);

    distance += unpack16(TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, float2(x0, y4)).rg);
    distance += unpack16(TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, float2(x1, y4)).rg);
    distance += unpack16(TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, float2(x2, y4)).rg);
    distance += unpack16(TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, float2(x3, y4)).rg);
    distance += unpack16(TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, float2(x4, y4)).rg);

    distance = distance/25.0;
    
    mainColor = float4(dist, pack16(distance));;
}
ENDCG
#END
