

#DEFPARAMS
TEXTURE_DIFFUSE = { "main Color", TEXTURE2D, "maintex" },
_TexOffset = { "uv offset", VEC2, "0.0, 0.0"},
_TexTilling = { "uv tilling", VEC2, "1.0, 1.0"},
_Alpha = {"alpha", FLOAT, "1.0"},
#END

#DEFTAG
ShaderName = "emoji"
RenderQueue = "Transparent"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA, ONE, ONE }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "light.inc"

struct appdata
{
    float2 vertex : POSITION;
    float2 uv : TEXCOORD0;
};

struct v2f
{
    float2 uv : TEXCOORD0;
    float4 vertex : SV_POSITION;
};

Texture2D TEXTURE_DIFFUSE;
SamplerState TEXTURE_DIFFUSE_SAMPLER;
float2 _TexOffset;
float2 _TexTilling;
float _Alpha;

v2f vert(appdata v)
{
    v2f o;
    float4 pos =ObjectToClipPos(float4(v.vertex * 0.01, 0.0, 1.0));
    o.vertex = UniformNDC(pos);
    o.uv = TRANSFORM_TEX(v.uv.xy, _TexOffset, _TexTilling);
    return o;
}

void frag(in v2f i, out float4 outColor : SV_Target0) 
{
    float4 mainColor = TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_SAMPLER, i.uv);
    mainColor.w = mainColor.w * _Alpha;
    outColor = mainColor;
}
ENDCG
#END
