local Faceinfo = require "videodecet.faceinfo";
local stringsplit = require "stringsplit"

--人脸数目 特征点耗时 属性耗时(毫秒) 
--第一个人脸的特征点(106*2 定义见商汤文档) 
--额外的134个特征点(定义见文档,检测不到全部-1)  
--倾斜角度(pitch roll yaw ) 
--人脸矩形区域(left,top,right,bottom) 
--遮挡信息(106个点 未被遮挡1.0, 遮挡值是0.0) 
--性别(-1:检测不到/1:男/2:女) 
--颜值(-1:检测不到 0~100?) 
--年龄(-1:检测不到 0~100?)  ... 紧接着第二个人脸特征点 ....
local facepointcount = 596;
local keypointcount = 106;
local extendedcount = 134;
local blockingcount = 106;

local paserservice = {}

function paserservice:GetKeyPointCount()
  return keypointcount;
end


function paserservice:PaserFile(agent, index, videosize, fullpath)
  for line in io.lines(fullpath) do
    local data = stringsplit(line, "%s", tonumber);
    local faces = {};
    local s = #data;
    for i=4, #data, facepointcount do
      local index = i;
      local fi = Faceinfo(videosize);
      for k=1, keypointcount do--提取关键点
        fi:PushKeypoint(data[index], data[index+1]);
        index = index + 2;          
      end
      for e=1, extendedcount do--提取关键点
        fi:PushExtended(data[index], data[index+1]);
        index = index + 2;
      end
      fi:PushRotation(data[index], data[index+1], data[index+2])
      index = index + 3;
      fi:PushRect(data[index], data[index+1], data[index+2], data[index+3])
      index = index + 4;
      for k=1, blockingcount do
        fi:PushBlocking(data[index]);
        index = index + 1;
      end
      table.insert(faces, fi);
    end
    agent:CallbackFunction(index, faces);
  end
end

return paserservice;