
local _DEBUG = true;
require "venusdebug"
require "utility"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"
local venusjson = require "venusjson"
local nodeutility = require "apolloutility.nodeutility"
local apollonode = require "apolloutility.apollonode"
local super3d = require "superme3d.superme3d"
local environment = require "superme3d.environment"
local pbrlighting = require "apolloutility.pbrlighting"
local videodecet = require "videodecet"
local textureloader = require "apolloutility.asynctexture.textureloader"
local emptyimage = require "apolloutility.emptyimage"

local renderqueue = require "apolloutility.renderqueue"
local NodeManager = require "superme3d.model.nodemanager"

local main = {}

function main:Timespan()
  local now = venuscore.ITimerSystem:GetTimevalue();
  local def = now - self.begintime;
  self.begintime = now;

  self.cumtime = self.cumtime + def;
  self.fps = self.fps + 1;

  if self.cumtime > 5 then
    local fps = self.fps / self.cumtime;
    self.fps = 0;
    self.cumtime = 0;
    -- LOG("FPS "..fps);
  end
  return def;
end


function main:CreateCameras(near, far, pos, lookat, up)
  self.maincamera = apollonode.CameraNode();--新建摄像机
	self.maincamera:CreatePerspectiveProjection(near, far);--设置摄像机
	self.maincamera:LookAt(pos, lookat, up);
  self.maincamera:Activate();--激活主摄像机
  
  self.post = apollonode.PostEffect();
  self.post:CreateResource("comm:script/apolloutility/posteffect/superme_blur.lua");
  self.maincamera:AttachPostEffect(self.post);
end

function main:Initialize()
  _COROUTINES_ON();

  self:CreateCameras(1, 5,
    mathfunction.vector3(0,0,1),
    mathfunction.vector3(0,0,0),
    mathfunction.vector3(0,1,0));

  self.ambient = apollonode.LightNode(apolloengine.LightComponent.LT_AMBIENT);
  self.ambient:SetColor(
    mathfunction.vector3(0.5,0.5,0.5));

  apolloengine.IPipelineSystem:SetMainCamera(self.maincamera:GetNode());
  apolloengine.IPipelineSystem:SetMaxShadowDistance(5.0);
  apolloengine.IPipelineSystem:SetShadowQuality(apolloengine.IPipelineSystem.SQ_HIGH);
  apolloengine.IEnvironmentSystem:EnableShadow();  --默认开启阴影

  self.direct = apollonode.LightNode(apolloengine.LightComponent.LT_DIRECTIONAL);
  self.direct:SetColor(
    mathfunction.vector3(0.294,0.294,0.294));
  local lightDirection = mathfunction.vector3(0.27, -0.452, -0.85);
  
  --local lightDirection = mathfunction.vector3(0.0, -1.0, -1.0);
  lightDirection:NormalizeSelf();
  self.direct:SetLocalDirection(lightDirection);

  self.direct:EnableShadowCaster(apolloengine.LightComponent.OPAQUE_SHADOW);
  self.shadowcamera, self.transparentshadowcamera = self.direct:GetShadowCamera();
  
  --self.shadowpost = apollonode.PostEffect();
  --self.shadowpost:CreateResource("docs:superme3d/Shadow/shadowblur.lua");
  --self.shadowcamera:AttachPostEffect(self.shadowpost);


  super3d:Initialize(self.maincamera);
  textureloader:Initialize();
  emptyimage:Initialize();
  renderqueue:Initialize(self.maincamera);

  self.rotation = mathfunction.Quaternion();
  -- self.model = apollonode.ModelNode();
  -- self.model:CreateResource("docs:dollmodel/dolleye", "docs:dollmaterial/dolleye.material");
  -- self.model:SetLocalScale(mathfunction.vector3(10.6,10.6,10.6));
  -- self.model:SetLocalPosition(mathfunction.vector3(0.0,-1.46,0.0));
  -- self.model:SetLocalRotation(mathfunction.Mathutility:RotateAxis(
  --    mathfunction.vector3(1,0,0), math.pi * 0.08)*mathfunction.Mathutility:RotateAxis(
  --       mathfunction.vector3(0,1,0), math.pi * 0.03));
  -- self.model:SetLoop(true);
  -- self.model:Play();.
  
  
  super3d:LoadBackground("docs:../../testcase/documents/nikki/IBLSkybox/Superme3D.json");
  
  super3d:LoadResource("docs:../../testcase/documents/nikki/DollEye/Superme3D.json");
  
  
  super3d:LoadResource("docs:../../testcase/documents/nikki/ClothBottom/Superme3D1.json");
  super3d:LoadResource("docs:../../testcase/documents/nikki/ClothBottom/Superme3D2.json");
  
  
  super3d:LoadResource("docs:../../testcase/documents/nikki/ClothTop/Superme3D1.json");
  super3d:LoadResource("docs:../../testcase/documents/nikki/ClothTop1/Superme3D1.json");
  
  
  super3d:LoadResource("docs:../../testcase/documents/nikki/ClothTop2/Superme3D1.json");
  super3d:LoadResource("docs:../../testcase/documents/nikki/ClothTop2/Superme3D2.json");
  
  
  super3d:LoadResource("docs:../../testcase/documents/nikki/ClothTop3/Superme3D1.json");
  
  
  super3d:LoadResource("docs:../../testcase/documents/nikki/DollSkin/Superme3D1.json");
  super3d:LoadResource("docs:../../testcase/documents/nikki/DollSkin/Superme3D2.json");
  super3d:LoadResource("docs:../../testcase/documents/nikki/DollSkin/Superme3D3.json");
  super3d:LoadResource("docs:../../testcase/documents/nikki/DollSkin/Superme3D4.json");
  
  super3d:LoadResource("docs:../../testcase/documents/nikki/DollSkin1/Superme3D1.json");
  
  super3d:LoadResource("docs:../../testcase/documents/nikki/DollHair/Superme3D.json");
  

  self.begintime = venuscore.ITimerSystem:GetTimevalue();
  self.cumtime = 0;
  self.fps = 0;

  apolloengine.Framework:AddSynchronizeUpdateCallback(self._Agent, "Update");
  apolloengine.Framework:AddTouchCallback(self._Agent, "OnTouch");

  LOG("initialize done");
  _COROUTINES_OFF();
  return true;
end

function main:Update()
  local def = self:Timespan();
  -- self.model:UpdateAnimation(def);

  -- self.rotation = self.rotation*mathfunction.Mathutility:RotateAxis(
  --   mathfunction.vector3(0,1,0), math.pi / 4.0 * def);
  -- self.model:SetLocalRotation(self.rotation);
  
  self.rotation = self.rotation*mathfunction.Mathutility:RotateAxis(
     mathfunction.vector3(0,1,0), math.pi / 8.0 * def);
    NodeManager.parentNode:SetLocalRotation(self.rotation);
end


function main:Abort()
  apolloengine.Framework:RemoveSynchronizeUpdateCallback(self._Agent, "Update");
  venuscore.IApplication:Abort();
end

function main:OnTouch(touchinfo)
 _COROUTINES_ON();
 
 local vec2 = touchinfo:GetTouchPoint(1);
  
 local tt = touchinfo:GetTouchType(1);
 if apolloengine.TouchInfo.TT_PRESS == tt  then
  self.point = vec2;
    
 elseif apolloengine.TouchInfo.TT_MOVE == tt then
  local rd = vec2 - self.point;
  self.point = vec2;
  local x = rd:x();
  local pos = self.maincamera:GetPosition();
  local dir = self.maincamera:GetForward();
  local rot = mathfunction.Mathutility:RotateAxis(
  mathfunction.vector3(0,1,0),
  -x);
  pos = pos * rot;
  dir = dir * rot;
  --self.maincamera:SetPosition(pos);
  --self.maincamera:SetForward(dir);
  
  --NodeManager.parentNode:SetPosition(pos);
  
 end

 _COROUTINES_OFF();
  
end


return main;
