local apolloengine = require "apolloengine"
local venuscore = require "venuscore"
local venusjson = require "venusjson"
local mathfunction = require "mathfunction"
local defined = require "superme3d.defined"
local beholder = require "superme3d.observer"
local utility = require "superme3d.utility"
local meshnode = require "superme3d.model.meshnode"
local bulletnode = require "superme3d.model.bulletnode"
local apollonode = require "apolloutility.apollonode"
local Object = require "classic"



local Bulletloader = {

}


function Bulletloader:RegisterEvents()
	self.OnCreatePhysicsEvent = utility:CreateInovation(self,self.LoadPhysics);
	self.OnParseResourceRootPathEvent = utility:CreateInovation(self,self.ParseRootpath);

	beholder.observe(defined.Event.ON_CREATE_PHYSICS,self.OnCreatePhysicsEvent);
	beholder.observe(defined.Event.ON_RESOURCE_ROOTPATH,self.OnParseResourceRootPathEvent);  
end


function Bulletloader:Initialize()
	self:RegisterEvents();
end

function Bulletloader:ParseRootpath(rootPath)
	self.rootPath = rootPath;
end

function Bulletloader:_GetBUlletPath(nameConfig)
	local bulletPath =  nameConfig;
	return bulletPath;
end


function Bulletloader:LoadPhysics(bulletConfig, nodemgr)
	if bulletConfig then 
		local bulletPath = bulletConfig.physics; --self:_GetBUlletPath(bulletConfig);
    	local meshnode = nodemgr:GetMeshNode(bulletConfig.mesh,bulletConfig.meshidx) ;       
		--local node = bulletnode;
		local skenode = nil;
		skenode = nodemgr.skeletonNode
	    local bullet= bulletnode()
		bullet:Initialize(bulletPath, meshnode,skenode);
		beholder.trigger(defined.Event.ON_CREATE_BULLET_FINISHED,bullet);

	end
end



Bulletloader:Initialize();

return Bulletloader;


