local headmodels = require "lightgame.modelanimation.headmodels"
local renderqueue = require "apolloutility.renderqueue"
local apollobehavior = require "apolloutility.behavior"
local apollonode = require "apolloutility.apollonode"
local mathfunction = require "mathfunction"
local apolloengine = require "apolloengine"
local videodecet = require "videodecet"
local venusjson = require "venusjson"
local Object = require "classic"
local b3 = require "behavior3"



local modelanimation = Object:extend();


function modelanimation:new(camera, rootdir, treepath, lightgameconfig)
  self.camera = camera;
  if lightgameconfig then
    if lightgameconfig.lightdirection then
      local dir = string.tovector(lightgameconfig.lightdirection);
      self.direct = apollonode.LightNode(apolloengine.LightComponent.LT_DIRECTIONAL);
      self.direct:SetLocalDirection(dir);
      if lightgameconfig.lightcolor then
        local col = string.tovector(lightgameconfig.lightcolor);
        self.direct:SetColor(col);
      else
        self.direct:SetColor(mathfunction.vector3(1,1,1));
      end    
    end
    if lightgameconfig.ambientcolor then  
      self.ambient = apollonode.LightNode(apolloengine.LightComponent.LT_AMBIENT);
      local col = string.tovector(lightgameconfig.ambientcolor);
      self.ambient:SetColor(col);
    end
    if lightgameconfig.skybox and 6 == #lightgameconfig.skybox then  
      self.skybox = apolloengine.TextureEntity();      
      for i, p in ipairs(lightgameconfig.skybox) do        
        self.skybox:PushMetadata(apolloengine.TextureFileMetadata(apolloengine.TextureEntity.TT_TEXTURECUBE_FRONT + i - 1, p));
      end      
      self.skybox:CreateResource();
      apolloengine.IMaterialSystem:SetGlobalParameter(apolloengine.ShaderEntity.SKY_BOX, self.skybox);
    end    
  end  
  
 
  self.headtargets = {}
  self.rootpath = rootdir;
  self.behaviortree = b3.BehaviorTree.new();
  self.blackboard = b3.Blackboard.new()  
  local path = rootdir..treepath;
  local tree = venusjson.LaodJsonFile(path);
  self.behaviortree:load(tree, apollobehavior, self);
  self.behaviortree:init(self, self.blackboard);
end

function modelanimation:Update(def)
  self.lastactiveindex = nil;
  self.blackboard:set("timespan", def);
  self.blackboard:set("camera", self.camera);
  self.behaviortree:tick(self, self.blackboard);
end

function modelanimation:CreateTarget(indexid)
  local target = headmodels(self.rootpath);
  self.headtargets[indexid] = target;
  return target;
end

function modelanimation:GetTarget(indexid)
  if indexid then
    return self.headtargets[indexid];
  end
  return nil;
end

function modelanimation:OnRecordStart()
  self.behaviortree:reset(self, self.blackboard);
  for _, head in ipairs(self.headtargets) do
    if head ~= nil then
      head:Reset();
    end
  end
end

function modelanimation:Exit()
  for _, head in ipairs(self.headtargets) do
    if head ~= nil then
      head:Clear();
    end
  end
  self.headtargets = nil;
  apolloengine.IMaterialSystem:EraseGlobalParameter(apolloengine.ShaderEntity.SKY_BOX);

  self.direct:Destroy();
  self.ambient:Destroy();
end

return modelanimation;