local sticker2drect3 = require "facecute.facesticker2d.sticker2drect3New"
local EffectAgent = require "facecute.effectagent"
local facesticker2d = require "facecute.facesticker2d.facesticker2d"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local Object = require "classic"
local renderqueue = require "apolloutility.renderqueue"

local facesticker2d3 = facesticker2d:extend();

--传入数据表，解析数据生成face组件
function facesticker2d3:ParseConfig(config, para)
    if (config == nil) then
        return false;
    end
    local version = config["version"];
    local res = true;
    local configParts = config["parts"];
    local compress_root = config["compress_root"];
    local len = #configParts;
    local index =1;
    local stickerPara={para[1]};
    stickerPara[3] = tonumber(version);
    for name, jPart in pairs(configParts) do
        local enabled = jPart.enable
        local noGroup = ((jPart.stickerGroup == nil) or (para.groupID == nil))
        local sameGroup = ((jPart.stickerGroup ~= nil) and (jPart.stickerGroup.index == para.groupID))
        if enabled and (noGroup or sameGroup) then
            local b = sticker2drect3(self.maincamera);
            --renderqueue:After(b);
            stickerPara[2]=name;
            res = res and b:ParseConfig(jPart, stickerPara, compress_root);
            if not res then
                ERROR("2d sticker parse failed: " .. name)
                break
            end
            table.insert(self.facesticker2ds, EffectAgent(b, name));
            table.insert(self.facesticker2dnames, name);
        end
    end
    self:AddToRenderQueue();
    return res;
end

function facesticker2d3:AddToRenderQueue()
    local index =1;
    local len = #self.facesticker2ds;
    for i =1, len do
        local b = self.facesticker2ds[i]:GetEffectObj();
        renderqueue:AddObjs(b);
    end
end

function facesticker2d3:SetRootNode(node)
    for _, def in ipairs(self.facesticker2ds) do
        def:SetRootNode(node);
    end
end

return facesticker2d3;