local mathfunction = require "mathfunction"
local utility = require "emoji.emojiUtility"
local model = require "emoji.model"

local lowerteeth = model:extend();

function lowerteeth:new()
  lowerteeth.super.new(self);
end

function lowerteeth:CreateModel(lowerteeth_config, attach_to_model, boundingbox, render_before)
  lowerteeth.super.CreateModel(self, lowerteeth_config, attach_to_model, boundingbox, render_before);
  
  if (self.model ~= nil) then
    self.lowerteeth_trans_left = lowerteeth_config.trans_jaw_left.weight;
    self.lowerteeth_trans_right = lowerteeth_config.trans_jaw_left.weight;
    self.lowerteeth_trans_forward = lowerteeth_config.trans_jaw_forward.weight;
    self.lowerteeth_rot = lowerteeth_config.rot_angle.weight;
    local trans = self.model:GetLocalPosition();
    self.trans_lowteeth = mathfunction.vector3(trans:x(), trans:y(), trans:z());
  end  
end

function lowerteeth:UpdateModel(emoji_data)
  if (self.model ~= nil and emoji_data ~= nil) then  
    local weights_dict = emoji_data.weights_dict;
    
    local trans = utility.TransFollowJaw(self.lowerteeth_trans_left, self.lowerteeth_trans_right, self.lowerteeth_trans_forward, weights_dict);
    self.model:SetLocalPosition(self.trans_lowteeth + trans);
    
    local quat2 = utility.RotateFollowJaw(self.lowerteeth_rot, weights_dict);
    self.model:SetLocalRotation(quat2); 
  end
end

return lowerteeth;