local mathfunction = require "mathfunction"
local utility = require "emoji.emojiUtility"
local model = require "emoji.model"

local animation = model:extend();

function animation:new()
  animation.super.new(self);
end

function animation:CreateModel(animation_config, attach_to_model, boundingbox, render_before)
  if (animation_config ~= nil) then
    self.model = utility.CreateAnimationModel(animation_config.mesh, animation_config.pos, true, true);
  end
  
  self:AttachToModel(attach_to_model); 
  self:SetBindBox(boundingbox);
  self:SetRenderQueue(render_before,true);
end

function animation:UpdateModel(input_data, def)
  if (self.model ~= nil) then
    self.model:UpdateAnimation(def);
  end
end

return animation;
