local mathfunction = require "mathfunction"
local apolloengine = require "apolloengine"
local apolloDefine = require "apolloutility.defiend"


local capsulecollision = {}

function capsulecollision:collide(point,radius, pointra,pointrb,radiusr)

  local ox = point - pointra;
  local temp = pointrb-pointra;
  local length = temp:Length();
  local dir = temp:Normalize();
  local projectLength = ox:Dot(dir);
  if projectLength<0  then
    return self:collidesphere(point,radius,pointra,radiusr);
  elseif projectLength>length then
    return self:collidesphere(point,radius,pointrb,radiusr);
  end
  local normal = ox - (dir*projectLength);
  local distance = normal:Length();
  if distance>=(radiusr+radius) then
    return false,nil;
  end
  local nornormal = normal / distance;
  --local offset = nornormal * (radiusr+radius - distance);
  local offset = (radiusr+radius)*(radiusr+radius) - distance*distance;
  return true,offset;
end

function capsulecollision:collidesphere(pointa,radiusa, pointb,radiusr)
  local disvec = pointa- pointb;
  local dis = disvec:Length();
  if dis<radiusr+radiusa then
    --local offset = disvec*(radiusr+radiusa-dis)/dis;
    
    local offset = (radiusr+radiusa)*(radiusr+radiusa)-dis*dis;
    local gradiant = disvec *(-2);
    
    return true,offset,{gradiant:x(),gradiant:y(),gradiant:z()};
  end
  return false,nil,nil;
end

function capsulecollision:collidewithd(point,radius, pointra,pointrb,radiusr)

  local ox = point - pointra;
  local temp = pointrb-pointra;
  local length = temp:Length();
  local dir = temp:Normalize();
  local projectLength = ox:Dot(dir);
  if projectLength<0  then
    return self:collidesphere(point,radius,pointra,radiusr);
  elseif projectLength>length then
    return self:collidesphere(point,radius,pointrb,radiusr);
  end
  local normal = ox - (dir*projectLength);
  local distance = normal:Length();
  if distance>=(radiusr+radius) then
    return false,nil,nil;
  end
  local nornormal = normal / distance;
  --local offset = nornormal * (radiusr+radius - distance);
  local offset = (radiusr+radius)*(radiusr+radius) - distance*distance;
  local orthpoint = pointrb - (dir*projectLength);
  local gradiant = (point - orthpoint)*(-2); --这是按距离平方算的导数，比较简单，哎。
  
  return true,offset,{gradiant:x(),gradiant:y(),gradiant:z()};
end



return capsulecollision;