local Venuscore = require "venuscore"
local apolloengine = require "apolloengine"
local ModelPoseGetter = Venuscore.VenusBehavior:extend("ModelPoseGetter"); 

local rootBone   = "Pelvis";

local bonesNames = {};

table.insert( bonesNames, "R_Shoulder" );
table.insert( bonesNames, "R_Elbow" );
table.insert( bonesNames, "R_Wrist" );
table.insert( bonesNames, "R_Hand" );
table.insert( bonesNames, "R_HandTip" );
table.insert( bonesNames, "R_Thumb" );
table.insert( bonesNames, "L_Shoulder" );
table.insert( bonesNames, "L_Elbow" );
table.insert( bonesNames, "L_Wrist" );
table.insert( bonesNames, "L_Hand" );
table.insert( bonesNames, "L_HandTip" );
table.insert( bonesNames, "L_Thumb" );
table.insert( bonesNames, "R_Hip" );
table.insert( bonesNames, "R_Knee" );
table.insert( bonesNames, "R_Ankle" );
table.insert( bonesNames, "R_Foot" );
table.insert( bonesNames, "L_Hip" );
table.insert( bonesNames, "L_Knee" );
table.insert( bonesNames, "L_Ankle" );
table.insert( bonesNames, "L_Foot" );
table.insert( bonesNames, "Neck" );
table.insert( bonesNames, "Head" );
table.insert( bonesNames, "HeadR" );
table.insert( bonesNames, "HeadL" );
table.insert( bonesNames, "HeadF" );
table.insert( bonesNames, "HeadB" );


function ModelPoseGetter:new()
    self.R_Shoulder = nil;
    self.R_Elbow    = nil;
    self.R_Wrist    = nil;
    self.R_Hand     = nil;
    self.R_HandTip  = nil;
    self.R_Thumb    = nil;

    self.L_Shoulder = nil;
    self.L_Elbow    = nil;
    self.L_Wrist    = nil;
    self.L_Hand     = nil;
    self.L_HandTip  = nil;
    self.L_Thumb    = nil;

    self.R_Hip      = nil;
    self.R_Knee     = nil;
    self.R_Ankle    = nil;
    self.R_Foot     = nil;

    self.L_Hip      = nil;
    self.L_Knee     = nil;
    self.L_Ankle    = nil;
    self.L_Foot     = nil;

    self.Neck       = nil;
    self.Head       = nil;
    self.HeadR      = nil;
    self.HeadL      = nil;
    self.HeadF      = nil;
    self.HeadB      = nil;
end

function ModelPoseGetter:Init()
  self.BoneNodes = 
  {
    self.R_Shoulder,
    self.R_Elbow   ,
    self.R_Wrist   ,
    self.R_Hand    ,
    self.R_HandTip ,
    self.R_Thumb   ,
    self.L_Shoulder,
    self.L_Elbow   ,
    self.L_Wrist   ,
    self.L_Hand    ,
    self.L_HandTip ,
    self.L_Thumb   ,
    self.R_Hip     ,
    self.R_Knee    ,
    self.R_Ankle   ,
    self.R_Foot    ,
    self.L_Hip     ,
    self.L_Knee    ,
    self.L_Ankle   ,
    self.L_Foot    ,
    self.Neck      ,
    self.Head      ,
    self.HeadR     ,
    self.HeadL     ,
    self.HeadF     ,
    self.HeadB     ,
  }
  
end

function ModelPoseGetter:GetBonePosition()
    self:Init();
    local ret = {};
    for i=1,26 do
        ret[i] = {}
        if self.BoneNodes[i]~=nil then  
            local transform = self.BoneNodes[i]:GetComponent(apolloengine.Node.CT_TRANSFORM);
            local worldpos = transform:GetWorldPosition();
            ret[i][1] = worldpos:x();
            ret[i][2] = worldpos:y();
            ret[i][3] = worldpos:z();
        end
    end

    if #ret==26 then
        local mid = {};
        mid[1] = (ret[13][1]+ret[17][1])/2;
        mid[2] = (ret[13][2]+ret[17][2])/2;
        mid[3] = (ret[13][3]+ret[17][3])/2;
        for i=1,26 do
            if  #ret[i]~=0 then
                ret[i][1] = ret[i][1] -  mid[1];
                ret[i][2] = ret[i][2] -  mid[2];
                ret[i][3] = ret[i][3] -  mid[3];
            end
        end
    end
    return ret;
end




for i=1, #bonesNames do
    ModelPoseGetter:MemberRegister(bonesNames[i],
    Venuscore.ScriptTypes.ReferenceType(
    apolloengine.Node:RTTI()
  )); 
end


return ModelPoseGetter;